/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: QueryOrderResponseVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/23 14:21
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import cn.freemud.entities.dto.PromotionMessageDto;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Builder;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class QueryOrderResponseVo {

    private String oid;
    /**
     * 订单Id二维码
     */
    private String oidBase64Image;

    private String shopId;

    private String thirdShopId;

    private String shopName;

    private String shopAddress;

    private String shopPhone;

    private String wxappid;
    /**
     * 取餐方式  0 立即取餐 1 预约取餐
     */
    private Integer takeMealType;

    /**
     * 取餐方式 描述
     */
    private String takeMealTypeDesc;

    /**
     * 取餐时间
     */
    private String takeMealTime;
    /**
     * 外卖预约
     */
    private String reserveDeliveryTime;
    /**
     * 是否外带 ,打包  1 是 0 否
     */
    private Integer takeOut;

    /**
     * 是否外带 描述
     */
    private String takeOutDesc;

    /**
     * 桌号
     */
    private String tableNumber;

    /**
     * 取餐码
     */
    private String takeCode;
    /**
     * 订单金额
     */
    private Long amount;
    /**
     * 商品总金额 不包括满减，配送费，包装费
     */
    private Long itemAmount;
    /**
     * 优惠总金额
     */
    private Long discountTotalAmount;
    /**
     * 包装费
     */
    private Long packageAmount;
    /**
     * 配送费
     */
    private Long deliveryAmount;
    /**
     * 限时折扣优惠金额
     */
    private Long discountLimitAmount;
    /**
     * 满减总优惠金额V1.5.2增加
     */
    private Long fullDiscountAmount;
    /**
     * 用户积分抵扣金额
     */
    private Long customerScoreAmount;
    /**
     * 用户积分抵扣提示
     */
    private String customerScorePrompt;
    /**
     * 订单类型  enum  OrderType
     */
    private Integer orderType;

    /**
     * 订单类型描述
     */
    private String orderTypeDesc;
    /**
     * 订单状态   enum  OrderStatus ,DeliverStatus=42 骑手取餐中
     */
    private Integer orderStatus;
    /**
     * 订单状态描述
     */
    private String orderStatusDesc;
    /**
     * 订单状态显示的对应描述
     */
    private String orderStatusDescText;
    /**
     * 取餐排队号  订单详情使用 默认为空
     */
    private String queueIndex;
    /**
     * 申请退款按钮
     */
    private Boolean buttonRefund;
    /**
     * 联系商家按钮
     */
    private Boolean buttonContactPartner;
    /**
     * 评价按钮
     */
    private Boolean buttonEvaluate;
    /**
     * 联系骑手按钮
     */
    private Boolean buttonContactRider;
    /**
     * 取餐码按钮
     */
    private Boolean buttonMealCode;
    /**
     * 支付状态  enum  PayStatus
     */
    private Integer payStatus;
    /**
     * 支付状态描述
     */
    private String payStatusDesc;
    /**
     * 支付时间
     */
    private String payCreateTime;
    /**
     * 付款方式  微信支付
     */
    private String orderPayType;

    /**
     * 支付渠道
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private String payChannel;
    /**
     * 付款单号
     */
    private String payVoucher;
    /**
     * 退款状态  enum  refundStatus
     */
    private Integer refundStatus;

    /**
     * 退款状态描述
     */
    private String refundStatusDesc;

    /**
     * 退款原因
     */
    private String refundReason;

    /**
     * 退款文案提示  若48小时后商家未处理，自动同意/拒绝退款
     */
    private String refundTips;
    /**
     * 退款单
     */
    private String rid;

    /**
     * 申请退款时间 yyyy-MM-dd HH:mm:ss
     */
    private String refundCreateTime;

    /**
     * 订单备注
     */
    private String orderRemark;
    /**
     * 订单创建时间
     */
    private String orderCreateTime;
    /**
     * 订单更新时间
     */
    private String modifiedTime;

    private Integer sex;
    private String sexDesc;
    /**
     * 收货办公楼
     */
    private String officeName;
    /**
     * 收货地址
     */
    private String receiveAddress;
    /**
     * 收货用户名
     */
    private String receiveUsername;
    /**
     * 收货电话
     */
    private String receiveMobile;

    private Integer distance;
    /**
     * 订单是否可申请退款  可申请退款条件 ：1 .支付未接单 2. 已接单，制作完成，配送中 ，用户可申请退款
     */
    private Boolean enableRefund;


    private List<ProductVo> products;

    private List<OrderAccountVo> orderAccounts;

    private PromotionMessageDto promotionMessage;

    /**
     * 优惠券信息
     */
    private CouponInfoVo couponInfo;

    /**
     * 是否有裂变活动分享
     */
    private String activityId;
    /**
     * 红包图片
     */
    private String redpacketsPicture;
    /**
     * 是否是第三方配送单
     */
    private Boolean hasThirdDelivery;

    /**
     * 骑手名称 商家自配送名称
     */
    private String riderName;
    /**
     * 骑手文案 商家自配送文案
     */
    private String riderText;
    /**
     * 骑手头像
     */
    private String riderPhoto;
    /**
     * 骑手电话
     */
    private String riderPhone;
    /**
     * 门店首页图片
     */
    private String shopImageUrl;
    /**
     * 门店经度
     */
    private String longitude;
    /**
     * 门店纬度
     */
    private String latitude;

    /**
     * 商品数量
     */
    private Integer productNum;
    /**
     * 订单流转时间
     */
    private ArrayList<OrderStatusFlow> orderStatusFlows;
    /**
     * 取餐页面订单流转状态
     */
    private ArrayList<TakeMealFlow> takeMealFlows;

    //支付有礼活动名称
    private String activityName;

    //支付有礼领券集合
    private List<PayGiftCouponVo> coupons;

    /**
     * 收件人省份
     */
    private String receiveProvince;

    /**
     * 收件人城市
     */
    private String receiveCity;

    /**
     * 收件人区
     */
    private String receiveRegion;

    /**
     * 订单业务类型 1:普通订单 2:虚拟订单 3:会员订单 4:积分商城订单 5:储值卡订单 6:卖券虚拟商品
     */
    private Integer bizType;

    @Data
    public static class OrderStatusFlow {
        /**
         * 时间描述
         */
        private String status;
        /**
         * 时间
         */
        private String orderTime;
    }

    @Data
    @Builder
    public static class TakeMealFlow {

        /**
         * 流程名称
         */
        private String name;
        /**
         * 是否显示
         */
        private Boolean active;
        /**
         * icon图标
         */
        private String icon;

    }
}
