package cn.freemud.entities.dto;

import cn.freemud.entities.dto.activity.ShareDiscountActivityDto;
import cn.freemud.entities.dto.shoppingCart.ActivityDiscountsDto;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;


@Data
public class ShoppingCartInfoDto {

    /**
     * 购物车实际选择商品，包含加价购商品
     */
    List<CartGoodsDetailDto> products;
    /**
     * 购物车原总价
     */
    private Long originalTotalAmount;
    /**
     * 购物车现总价
     */
    private Long totalAmount;
    /**
     * 购物车总折扣价(优惠价)
     */
    private Long totalDiscountAmount;
    /**
     * 购物车总包装费
     */
    private Long packageAmount;
    /**
     * 积分扣减金额
     */
    private Long scoreReduceAmount;
    /**
     * 抵用积分
     */
    private Long reduceScore;

    /**
     * 请求计算的商品均摊信息
     */
    List<ShareDiscountActivityDto> shareDiscountActivityDtos;

    /**
     * 第一次使用会员卡需多支付的金额 单位为分
     */
    private Integer memberCardAmount;

    /**
     * 会员卡原价
     */
    private Integer cardOriginalAmount;

    /**
     * 会员卡优惠金额
     */
    private Integer cardDiscountAmount;

    /**
     * 订单享受的促销活动
     */
    List<ActivityDiscountsDto> activityDiscountsDtos;


    @Data
    public static class CartGoodsDetailDto {
        /**
         * spuId
         */
        private String spuId;
        /**
         * spuId  如果是单品 skuId=spuId
         */
        private String skuId;
        /**
         * 商品的名称
         */
        private String spuName;
        /**
         * 如果是单品 skuName=spuName
         */
        private String skuName;
        /**
         * 商品行原始价格
         */
        private Long originalPrice;
        /**
         * 商品图片
         */
        private String picture;
        /**
         * 商品的数量
         */
        private Integer qty;
        /**
         * 商品行优惠总金额=数量*单个商品优惠金额
         */
        private Integer totalDiscountAmount;
        /**
         * 是否包含商品券
         */
        private Boolean hasProductCoupon = false;
        /**
         * 1.5.5版本添加
         * 商品参与活动类型(61:买一赠一)
         */
        private Integer activityType;

        /**
         * 1.6.0 版本增加  节点ID
         */
        private String nodeId;
        /**
         * 1.6.0 版本增加 分类名
         */
        private String categoryName;

        /**
         * 配料或属性
         */
        private List<CartGoodsExtra> extraList = new ArrayList<>(0);

        @Data
        public final static class CartGoodsExtra {
            /**
             * 属性Id
             */
            private String attributeId;
            /**
             * 属性名
             */
            private String attributeName;
        }

        /**
         * 获取extras attributeNames
         */
        public String getAttributeNames() {
            String extras = "";
            if (CollectionUtils.isNotEmpty(this.extraList)) {
                extras = extraList.stream().map(CartGoodsDetailDto.CartGoodsExtra::getAttributeName).collect(Collectors.joining("/"));
            }
            return JSON.toJSONString(OrderProductAddInfo.builder().attributeNames(extras).build());
        }

    }

}
