package cn.freemud.entities.dto;

import lombok.Data;

import java.util.List;

@Data
public class ActivityUpdateStockRequestDto {
    /**
     * 接口版本
     */
    private String ver;
    /**
     * 交易订单号
     */
    private String orderId;
    /**
     * 商户号
     */
    private String partnerCode;
    /**
     * 门店ID
     */
    private String storeId;
    /**
     * 活动集合
     */
    List<StockBeanDto> stock;
    @Data
    public static class StockBeanDto {
        /**
         * 活动号
         */
        private String activityCode;
        /**
         * 活动参与次数
         */
        private Integer activityStock;
        /**
         * 商品库存
         */
         private List<GoodsStock> goodsStock;
         @Data
        public static class GoodsStock {
             /**
              * 活动中优惠商品的id
              */
             private String goodsId;
             /**
              * 库存
              */
             private Integer stock;
             /**
              * 优惠等级，当优惠等级库存 不共享时此字段必传
              */
             private Integer beneﬁtSeq;
         }
    }
}
