package cn.freemud.management.service.impl;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.management.adapter.SaasMallOrderAdapter;
import cn.freemud.management.entities.dto.request.activity.GroupWorkRefundRequest;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.entities.dto.response.activity.GroupWorkRefundResponse;
import cn.freemud.management.entities.dto.response.order.OrderManagerResponse;
import cn.freemud.management.entities.dto.response.pay.PayRefundResponse;
import cn.freemud.management.enums.OperateType;
import cn.freemud.management.enums.OrderMarketType;
import cn.freemud.management.enums.ResponseResult;
import cn.freemud.management.intercept.OrderServiceException;
import cn.freemud.management.service.OrderBaseService;
import cn.freemud.management.service.OrderManagerService;
import cn.freemud.management.service.handle.*;
import cn.freemud.management.util.ResponseUtil;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.constant.ResponseConstant;
import com.freemud.application.sdk.api.ordercenter.enums.AfterSalesStatus;
import com.freemud.application.sdk.api.ordercenter.enums.RefundModeEnum;
import com.freemud.application.sdk.api.ordercenter.request.AfterOrderExtInfoDto;
import com.freemud.sdk.api.assortment.order.domain.ResponseCodeConstant;
import com.freemud.sdk.api.assortment.order.enums.PayRefundStatus;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import com.netflix.discovery.converters.Auto;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: rrr
 * @Package cn.freemud.management.service.impl
 * @Description: 外卖订单履单操作
 * @author: zhiheng.zhang
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class MallOrderMangerServiceImpl implements OrderManagerService {
    @Autowired
    private MallOrderHandle mallOrderHandle;
    @Autowired
    private OrderBaseService orderBaseService;
    @Autowired
    private PaymentHandle paymentHandle;
    @Autowired
    private DeliveryHandle deliveryHandle;
    @Autowired
    private StockHandle stockHandle;
    @Autowired
    private ActivityHandle activityHandle;

    /**
     * 同意退款
     *
     * @param request
     * @param orderBean
     * @return
     */
    @Override
    public BaseResponse<OrderManagerResponse> orderAgreeRefund(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        //取消配送单
//        deliveryHandle.cancelDelivery(orderBean,request);
        boolean flag = false;
        Byte refundMode = RefundModeEnum.REFUND_ALL.getIndex();
        if(null != orderBean.getAfterSalesOrderResp() && StringUtils.isNotEmpty(orderBean.getAfterSalesOrderResp().getExtInfo())){
            AfterOrderExtInfoDto afterOrderExtInfoDto = JSONObject.parseObject(orderBean.getAfterSalesOrderResp().getExtInfo(),AfterOrderExtInfoDto.class);
            if(null !=afterOrderExtInfoDto) {
                refundMode = afterOrderExtInfoDto.getRefundMode();
            }
        }

        if((StringUtils.isNotEmpty(request.getOperator()) && "自动任务".equalsIgnoreCase(request.getOperator())) && Objects.equals(RefundModeEnum.REFUND_ALL.getIndex(),refundMode) && Objects.nonNull(orderBean.getAfterSalesOrderResp()) && Objects.equals(AfterSalesStatus.PENDING.getIndex(), orderBean.getAfterSalesOrderResp().getAfterSalesStatus())){
            // 修改售后单状态为退货中
            BaseResponse mallOrderAgreeApply = mallOrderHandle.mallOrderAgreeApply(request, orderBean);
            if (mallOrderAgreeApply == null || ObjectUtils.notEqual(ResponseResult.SUCCESS.getCode(), mallOrderAgreeApply.getCode())) {
                return ResponseUtil.error(ResponseResult.AGREE_REFUND_APPLY_ORDER_FAIL);
            }
            // 拼团订单主动退款触发通知促销
            if (Objects.equals(com.freemud.sdk.api.assortment.order.enums.OrderSourceType.SAASMALL.getCode(), orderBean.getSource())
                    && Objects.equals(OrderMarketType.GROUPB.getIndex(), orderBean.getMarketingType())) {
                GroupWorkRefundResponse refundResponse = activityHandle.groupWorkRefund(orderBean);
                if (Objects.isNull(refundResponse) || !Objects.equals(ResponseConstant.SUCCESS_RESPONSE_CODE, refundResponse.getStatusCode())) {
                    return ResponseUtil.error(ResponseResult.SPELL_GROUP_REFUND_ERROR);
                }
            }

            //支付退款
            PayRefundResponse refundResponse = new PayRefundResponse();
            try {
                refundResponse = paymentHandle.refund(request, orderBean);
            } catch (OrderServiceException orderEx) {
                return ResponseUtil.error(orderEx.getResult());
            }
            //订单同意退款
            mallOrderHandle.refundAgree(request, refundResponse, orderBean);
            // 推送pos、微信消息中心
            orderBaseService.sendMessage(orderBean, OperateType.ORDER_AGREE_REFUND, request.getReason());
            //todo  可以考虑基于订单回调异步实现
            //冲正库存
            stockHandle.revert(request, orderBean);
        }else {
            if (Objects.equals(RefundModeEnum.REFUND_ALL.getIndex(), refundMode) && Objects.nonNull(orderBean.getAfterSalesOrderResp()) && Objects.equals(AfterSalesStatus.PENDING.getIndex(), orderBean.getAfterSalesOrderResp().getAfterSalesStatus())) {
                // 修改售后单状态为退货中
                mallOrderHandle.mallOrderAgreeApply(request, orderBean);
            } else {
                // 拼团订单主动退款触发通知促销
                if (Objects.equals(com.freemud.sdk.api.assortment.order.enums.OrderSourceType.SAASMALL.getCode(), orderBean.getSource())
                        && Objects.equals(OrderMarketType.GROUPB.getIndex(), orderBean.getMarketingType())) {
                    GroupWorkRefundResponse refundResponse = activityHandle.groupWorkRefund(orderBean);
                    if (Objects.isNull(refundResponse) || !Objects.equals(ResponseConstant.SUCCESS_RESPONSE_CODE, refundResponse.getStatusCode())) {
                        return ResponseUtil.error(ResponseResult.SPELL_GROUP_REFUND_ERROR);
                    }
                }

                //支付退款
                PayRefundResponse refundResponse = new PayRefundResponse();
                try {
                    refundResponse = paymentHandle.refund(request, orderBean);
                } catch (OrderServiceException orderEx) {
                    return ResponseUtil.error(orderEx.getResult());
                }
                //订单同意退款
                mallOrderHandle.refundAgree(request, refundResponse, orderBean);
                // 推送pos、微信消息中心
                orderBaseService.sendMessage(orderBean, OperateType.ORDER_AGREE_REFUND, request.getReason());
                //todo  可以考虑基于订单回调异步实现
                //冲正库存
                stockHandle.revert(request, orderBean);
            }
        }
        return ResponseUtil.success();
    }

    /**
     * 拒绝退款
     *
     * @param request
     * @param orderBean
     * @return
     */
    @Override
    public BaseResponse<OrderManagerResponse> orderRejectRefund(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        //拒绝退款
        mallOrderHandle.mallRefundReject(request,orderBean);
        // 推送pos、微信消息中心
        orderBaseService.sendMessage(orderBean, OperateType.ORDER_REJECT_REFUND, request.getReason());
        return ResponseUtil.success();
    }

    /**
     * 拒单
     *
     * @param request
     * @param orderBean
     * @return
     */
    @Override
    public BaseResponse<OrderManagerResponse> orderReject(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        //支付退款
        PayRefundResponse refundResponse = new PayRefundResponse();
        try {
            if(null != orderBean.getOrderPayItem() && orderBean.getOrderPayItem().size()>0){
                refundResponse = paymentHandle.multiRefund(orderBean);
            }else{
                refundResponse = paymentHandle.refund(request, orderBean);
            }
        } catch (OrderServiceException orderEx){ // 爱马哥兼容，不抛错
            return ResponseUtil.error(orderEx.getResult());
        }
        //订单拒单
        mallOrderHandle.mallOrderReject(request, refundResponse, orderBean);
        // 推送pos、微信消息中心
        orderBaseService.sendMessage(orderBean, OperateType.ORDER_REJECT, request.getReason());
        //todo  可以考虑基于订单回调异步实现
        //冲正库存
        stockHandle.revert(request,orderBean);
        return ResponseUtil.success();
    }

}
