package cn.freemud.entities.dto.pay;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class OrderInvoiceRequest {
    @ApiModelProperty("商户号")
    @NotEmpty(message = "商户号不能为空")
    private String partnerId;

    @ApiModelProperty("发票类型")
    @NotNull(message = "发票类型不能为空")
    private Integer invoiceType;

    @ApiModelProperty("发票抬头")
    private String title;

    @ApiModelProperty("发票内容")
    @NotBlank(message = "发票内容不能为空")
    private String content;

    @ApiModelProperty("税号")
    private String taxNo;

    @ApiModelProperty("发票金额 单位分")
    @NotNull(message = "发票金额不能为空")
    private Integer amount;

    @ApiModelProperty("发票地址")
    private String address;

    @ApiModelProperty("电话号码")
    private String phoneNo;

    @ApiModelProperty("银行账号")
    private String bankCardNo;

    @ApiModelProperty("开户行")
    private String invoiceBank;

    @ApiModelProperty("发票URL地址")
    @NotBlank(message = "发票URL地址不能为空")
    private String invoiceUrl;

    @ApiModelProperty("用户Id")
    @NotBlank(message = "用户Id不能为空")
    private String userId;

    @ApiModelProperty("开票流水号")
    @NotBlank(message = "开票流水号不能为空")
    private String invoiceNo;

    @ApiModelProperty("税率")
    @NotBlank(message = "税率不能为空")
    private String taxRate;

    @ApiModelProperty("提取号")
    @NotBlank(message = "提取号不能为空")
    private String pickUpNo;

    @ApiModelProperty("扫码开票截至时间")
    @NotBlank(message = "扫码开票截至时间不能为空")
    private String endingDate;

    @ApiModelProperty("关联订单号")
    @NotNull(message = "关联订单号不能为空")
    private List<String> orderCodes;
}
