/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ApiApplication
 * @Package cn.freemud
 * @Description:
 * @author: xudong.cai
 * @date: 2018/5/4 10:45
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud;

import com.freemud.application.sdk.api.log.LogThreadLocal;
import feign.RequestInterceptor;
import org.apache.commons.lang.StringUtils;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;
import tk.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.circuitbreaker.EnableCircuitBreaker;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.EnableAspectJAutoProxy;


@ServletComponentScan
//@ImportAutoConfiguration(classes = {EmailAlertConfig.class, DataSourcesConfig.class})
@MapperScan({"com.freemud.platform.common.manager.dao",
        "com.freemud.api.assortment.datamanager.manager.dao",
        "com.freemud.api.assortment.datamanager.queue.dao",
        "com.freemud.api.assortment.datamanager.rbac.dao",
        "com.freemud.sdk.api.assortment.orderdistributor.mapper"})
@EnableCircuitBreaker
@SpringBootApplication
@EnableDiscoveryClient
@EnableAspectJAutoProxy
@ComponentScan({"cn.freemud","com.freemud"})
@EnableFeignClients
@EnableAutoConfiguration
public class ApiApplication {

    private static final String GRAY_VERSION_PROD = "PROD"; //生产版本
    private static final String GRAY_VERSION_GRAY = "GRAY"; //灰度版本

    public static void main(String[] args) {
        String getenv = System.getenv("VERSION_FLAG");
        System.setProperty("eureka.instance.metadataMap.version", StringUtils.isEmpty(getenv) ? GRAY_VERSION_PROD : GRAY_VERSION_GRAY.equals(getenv) ? GRAY_VERSION_GRAY : GRAY_VERSION_PROD);
        SpringApplication.run(ApiApplication.class, args);
    }

    @Bean("jasyptStringEncryptorFreemud")
    public StringEncryptor stringEncryptor() {
        PooledPBEStringEncryptor encryptor = new PooledPBEStringEncryptor();
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        config.setPassword("configDbkey");
        config.setAlgorithm("PBEWithMD5AndDES");
        config.setKeyObtentionIterations("1000");
        config.setPoolSize("1");
        config.setProviderName("SunJCE");
        config.setSaltGeneratorClassName("org.jasypt.salt.RandomSaltGenerator");
        config.setStringOutputType("base64");
        encryptor.setConfig(config);
        return encryptor;
    }

    /**
     * 定义feign-client 带上x-transaction-id
     *
     * @return
     */
    @Bean
    public RequestInterceptor headerInterceptor() {
        return requestTemplate -> requestTemplate.header("x-transaction-id", LogThreadLocal.getTrackingNo());
    }

}
