package cn.freemud.client;

import cn.freemud.entities.dto.wechat.GetAuthorizerRequestDto;
import cn.freemud.entities.dto.wechat.GetTokenResponseDto;
import cn.freemud.entities.vo.WechatGroupBuyVo;
import cn.freemud.service.thirdparty.EcologyAdminApplicationClient;
import cn.freemud.service.thirdparty.WeChatClient;
import com.freemud.sdk.api.assortment.order.request.order.GroupBuyRequest;
import com.freemud.sdk.api.assortment.order.response.order.GroupBuyResponse;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.ArrayList;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0.0
 * @Description:
 * @author: hui.miao
 * @date: 2020-11-28 15:12
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class EcologyAdminApplicationClientTest {

    @Autowired
    private EcologyAdminApplicationClient ecologyAdminApplicationClient;
    @Autowired
    private WeChatClient weChatClient;

    @Test
    public void accessToken() {
        String partnerId = "1864";
        String appId = "wxb78fb7c6218cb52c";
        GetAuthorizerRequestDto getAuthorizerRequestDto = new GetAuthorizerRequestDto();
        getAuthorizerRequestDto.setPartnerId(partnerId);
        getAuthorizerRequestDto.setAuthorizerAppid(appId);
        GetTokenResponseDto getTokenResponseDto = ecologyAdminApplicationClient.getAuthorizerAccessToken(getAuthorizerRequestDto);
        log.debug(getTokenResponseDto.toString());
    }

    @Test
    public void groupBuy() {
        String partnerId = "1864";
        String appId = "wxb78fb7c6218cb52c";
        GetAuthorizerRequestDto getAuthorizerRequestDto = new GetAuthorizerRequestDto();
        getAuthorizerRequestDto.setPartnerId(partnerId);
        getAuthorizerRequestDto.setAuthorizerAppid(appId);
        GetTokenResponseDto getTokenResponseDto = ecologyAdminApplicationClient.getAuthorizerAccessToken(getAuthorizerRequestDto);

        String accessToken = getTokenResponseDto.getResult().getAccessToken();
        log.debug("token:{}", accessToken);

        GroupBuyRequest groupBuyRequest = new GroupBuyRequest();
        groupBuyRequest.setOut_trade_no("88888888");
        groupBuyRequest.setRecv_openid("oORZK5NUo7sDvuJwPwbehqq360Tw");
        groupBuyRequest.setScene(1);

        // pay_list
        GroupBuyRequest.PayList payList = new GroupBuyRequest.PayList();
        List<GroupBuyRequest.UserInfo> userInfoList = new ArrayList<>();

        GroupBuyRequest.UserInfo userInfo1 = new GroupBuyRequest.UserInfo();
        userInfo1.setOpenid("oORZK5A8hrejg0uBVSlkpv-KPgv4");
        userInfo1.setAmount(1);
        GroupBuyRequest.UserInfo userInfo2 = new GroupBuyRequest.UserInfo();
        userInfo2.setOpenid("ohvIM0VbQw41wCznsgYHu7W6W_bA");
        userInfo2.setAmount(2);
        GroupBuyRequest.UserInfo userInfo3 = new GroupBuyRequest.UserInfo();
        userInfo3.setOpenid("oORZK5MHMBm78PO302NdRyzIY5K0");
        userInfo3.setAmount(3);

        userInfoList.add(userInfo1);
        userInfoList.add(userInfo2);
        userInfoList.add(userInfo2);

        payList.setUser_info(userInfoList);
        groupBuyRequest.setPay_list(payList);

        // desc
        GroupBuyRequest.Desc desc = new GroupBuyRequest.Desc();
        desc.setText_desc("非码商户 20201128");

        //String requestUrl = "https://api.weixin.qq.com/wxa/business/groupBuy/createOrder?access_token=" + accessToken;

        GroupBuyResponse groupBuyResponse = weChatClient.groupBuyCreateOrder(accessToken, groupBuyRequest);
        log.debug(groupBuyResponse.toString());
    }
}
