package cn.freemud.entities.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.NotEmpty;

@Data
public class BaseRequestVo {

    private String sessionId;
    /**
     * 商户Id
     */
    @NotEmpty(message = "partnerId不能为空")
    private String partnerId;
    /**
     * 门店Id
     */
    @NotEmpty(message = "shopId不能为空")
    private String shopId;

    /**
     * 下单类型 CreateOrderType 外卖、到店、商城
     */
    private Integer orderType;

    /**
     * 渠道类型 OrderChannelType
     */
    private String channelType;
}
