package cn.freemud.manager.dao.entity;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

@Data
@Table(name = "open_api_encrypt")
public class OpenApiEncrypt{
    @Id
    private Long id;

    /**
     * 商户ID
     */
    @Column(name = "partner_id")
    private String partnerId;

    /**
     * appid
     */
    private String appid;

    /**
     * 开发者id
     */
    private String devid;

    @Column(name = "callback_url")
    private String callbackUrl;

    @Column(name = "client_private_key")
    private String clientPrivateKey;

    /**
     * 公钥
     */
    @Column(name = "client_public_key")
    private String clientPublicKey;

    /**
     * 私钥
     */
    @Column(name = "server_private_key")
    private String serverPrivateKey;

    @Column(name = "server_public_key")
    private String serverPublicKey;

    @Column(name = "gmt_created")
    private Date gmtCreated;

    /**
     * 备注
     */
    private String remark;

    private static final long serialVersionUID = 1L;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取商户ID
     *
     * @return partner_id - 商户ID
     */
    public String getPartnerId() {
        return partnerId;
    }

    /**
     * 设置商户ID
     *
     * @param partnerId 商户ID
     */
    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId == null ? null : partnerId.trim();
    }

    /**
     * 获取appid
     *
     * @return appid - appid
     */
    public String getAppid() {
        return appid;
    }

    /**
     * 设置appid
     *
     * @param appid appid
     */
    public void setAppid(String appid) {
        this.appid = appid == null ? null : appid.trim();
    }

    /**
     * 获取开发者id
     *
     * @return devid - 开发者id
     */
    public String getDevid() {
        return devid;
    }

    /**
     * 设置开发者id
     *
     * @param devid 开发者id
     */
    public void setDevid(String devid) {
        this.devid = devid == null ? null : devid.trim();
    }

    /**
     * @return callback_url
     */
    public String getCallbackUrl() {
        return callbackUrl;
    }

    /**
     * @param callbackUrl
     */
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl == null ? null : callbackUrl.trim();
    }

    /**
     * @return client_private_key
     */
    public String getClientPrivateKey() {
        return clientPrivateKey;
    }

    /**
     * @param clientPrivateKey
     */
    public void setClientPrivateKey(String clientPrivateKey) {
        this.clientPrivateKey = clientPrivateKey == null ? null : clientPrivateKey.trim();
    }

    /**
     * 获取公钥
     *
     * @return client_public_key - 公钥
     */
    public String getClientPublicKey() {
        return clientPublicKey;
    }

    /**
     * 设置公钥
     *
     * @param clientPublicKey 公钥
     */
    public void setClientPublicKey(String clientPublicKey) {
        this.clientPublicKey = clientPublicKey == null ? null : clientPublicKey.trim();
    }

    /**
     * 获取私钥
     *
     * @return server_private_key - 私钥
     */
    public String getServerPrivateKey() {
        return serverPrivateKey;
    }

    /**
     * 设置私钥
     *
     * @param serverPrivateKey 私钥
     */
    public void setServerPrivateKey(String serverPrivateKey) {
        this.serverPrivateKey = serverPrivateKey == null ? null : serverPrivateKey.trim();
    }

    /**
     * @return server_public_key
     */
    public String getServerPublicKey() {
        return serverPublicKey;
    }

    /**
     * @param serverPublicKey
     */
    public void setServerPublicKey(String serverPublicKey) {
        this.serverPublicKey = serverPublicKey == null ? null : serverPublicKey.trim();
    }

    /**
     * @return gmt_created
     */
    public Date getGmtCreated() {
        return gmtCreated;
    }

    /**
     * @param gmtCreated
     */
    public void setGmtCreated(Date gmtCreated) {
        this.gmtCreated = gmtCreated;
    }

    /**
     * 获取备注
     *
     * @return remark - 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 设置备注
     *
     * @param remark 备注
     */
    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", id=").append(id);
        sb.append(", partnerId=").append(partnerId);
        sb.append(", appid=").append(appid);
        sb.append(", devid=").append(devid);
        sb.append(", callbackUrl=").append(callbackUrl);
        sb.append(", clientPrivateKey=").append(clientPrivateKey);
        sb.append(", clientPublicKey=").append(clientPublicKey);
        sb.append(", serverPrivateKey=").append(serverPrivateKey);
        sb.append(", serverPublicKey=").append(serverPublicKey);
        sb.append(", gmtCreated=").append(gmtCreated);
        sb.append(", remark=").append(remark);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}