package cn.freemud.config;

import com.freemud.application.sdk.api.constant.RestTemplateConstant;
import com.freemud.application.sdk.api.membercenter.config.MemberCenterProperties;
import com.freemud.application.sdk.api.membercenter.config.MemberExtendProperties;
import com.freemud.application.sdk.api.membercenter.config.MemberPropertyProperties;
import com.freemud.application.sdk.api.membercenter.config.MermberScoreProperties;
import com.freemud.application.sdk.api.productcenter.config.InventoryCenterProperties;
import com.freemud.application.sdk.api.productcenter.config.ProductCenterProperties;
import com.freemud.application.sdk.api.storecenter.config.StoreCenterProperties;
import com.freemud.application.sdk.api.util.BaseRequestUtils;
import com.freemud.application.sdk.api.util.BaseRequestUtils;
import com.freemud.application.sdk.api.util.RestTemplateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@Configuration
public class PreReleaseBeanConfig {


    @Profile({"pre-release"})
    @Bean(name = {"member.center"})
    public RestTemplate centerRestTemplateQa(@Qualifier("memberCenterProperties") MemberCenterProperties properties) {
        return BaseRequestUtils.getRestTemplate(properties.getRetryTimes(), properties.getConnectTimeOut(), properties.getReadTimeOut());
    }

    @Profile({"pre-release"})
    @Bean(name = {"member.score"})
    public RestTemplate scoreRestTemplateQa(@Qualifier("mermberScoreProperties") MermberScoreProperties properties) {
        return BaseRequestUtils.getRestTemplate(properties.getRetryTimes(), properties.getConnectTimeOut(), properties.getReadTimeOut());
    }

    @Profile({"pre-release"})
    @Bean(name = {"member.property"})
    public RestTemplate propertyRestTemplateQa(@Qualifier("memberPropertyProperties") MemberPropertyProperties properties) {
        return BaseRequestUtils.getRestTemplate(properties.getRetryTimes(), properties.getConnectTimeOut(), properties.getReadTimeOut());
    }

    @Profile({"pre-release"})
    @Bean(name = {"member.extend"})
    public RestTemplate extendRestTemplateQa(@Qualifier("memberExtendProperties") MemberExtendProperties properties) {
        return BaseRequestUtils.getRestTemplate(properties.getRetryTimes(), properties.getConnectTimeOut(), properties.getReadTimeOut());
    }

    @Profile({"pre-release"})
    @Bean(name = {"productRestTemplate"})
    public RestTemplate productRestTemplate(@Autowired ProductCenterProperties productCenterProperties) {
        Map<String, Integer> map = new HashMap(16);
        if (productCenterProperties.getRetryTimes() != null) {
            map.put("retryTimes", productCenterProperties.getRetryTimes());
        }

        if (productCenterProperties.getConnectTimeOut() != null) {
            map.put("connectTimeOut", productCenterProperties.getConnectTimeOut());
        }

        if (productCenterProperties.getReadTimeOut() != null) {
            map.put("readTimeOut", productCenterProperties.getReadTimeOut());
        }

        return RestTemplateUtils.getRestTemplateByType(map);
    }
    @Profile({"pre-release"})
    @Bean(name = "inventoryRestTemplate")
    public RestTemplate inventoryRestTemplate(@Autowired InventoryCenterProperties inventoryCenterProperties) {
        Map<String, Integer> map = new HashMap<>(16);
        if (inventoryCenterProperties.getRetryTimes() != null) {
            map.put(RestTemplateConstant.RETRY_TIMES, inventoryCenterProperties.getRetryTimes());
        }
        if (inventoryCenterProperties.getConnectTimeOut() != null) {
            map.put(RestTemplateConstant.CONNECT_TIMEOUT, inventoryCenterProperties.getConnectTimeOut());
        }
        if (inventoryCenterProperties.getReadTimeOut() != null) {
            map.put(RestTemplateConstant.READ_TIMEOUT, inventoryCenterProperties.getReadTimeOut());
        }
        return RestTemplateUtils.getRestTemplateByType(map);
    }
    @Profile({"pre-release"})
    @Bean(name = {"storeRestTemplate"})
    public RestTemplate proRestTemplateTemplate(@Autowired StoreCenterProperties properties) {
        return BaseRequestUtils.getRestTemplate(properties.getRetryTimes(), properties.getConnectTimeOut(), properties.getReadTimeOut());
    }
}
