package cn.freemud.demo.entities.factory;

import cn.freemud.demo.entities.bo.BaseAddGoodsBO;
import cn.freemud.demo.entities.bo.MCoffeeAddGoodsBO;
import cn.freemud.demo.entities.bo.MallAddGoodsBO;
import cn.freemud.demo.entities.bo.PlatformAddGoodsBO;
import cn.freemud.demo.entities.dto.AddGoodsRequestDTO;
import cn.freemud.demo.entities.dto.BaseRequestDTO;
import cn.freemud.enums.OrderChannelType;
import cn.freemud.service.impl.ShoppingCartMallServiceImpl;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.base.SDKCommonBaseContextWare;

public class ServiceBoFactory {

    private final static String macafePartnerId = "";

    public static BaseAddGoodsBO createAddGoodsBOInstance(String params) {
        BaseAddGoodsBO baseAddGoodsBO;
        AddGoodsRequestDTO baseRequestDTO = JSON.parseObject(params, AddGoodsRequestDTO.class);
        if (baseRequestDTO.getChannelType() != null && OrderChannelType.SAASMALL.getCode().equals(baseRequestDTO.getChannelType())){
            baseAddGoodsBO = createMallBO(baseRequestDTO);
        } else if (baseRequestDTO.getPartnerId().equals(macafePartnerId)) {
            baseAddGoodsBO = createMCoffeeBO(baseRequestDTO);
        } else {
            baseAddGoodsBO = createPlatformBO(baseRequestDTO);
        }
        return baseAddGoodsBO;
    }

    private static MallAddGoodsBO createPlatformBO(AddGoodsRequestDTO baseRequestDTO) {
        MallAddGoodsBO mallAddGoodsBO = new MallAddGoodsBO();
        return mallAddGoodsBO;
    }

    private static MCoffeeAddGoodsBO createMCoffeeBO(AddGoodsRequestDTO baseRequestDTO) {
        MCoffeeAddGoodsBO mCoffeeAddGoodsBO = new MCoffeeAddGoodsBO();
        return mCoffeeAddGoodsBO;
    }

    private static BaseAddGoodsBO createMallBO(AddGoodsRequestDTO baseRequestDTO) {
        PlatformAddGoodsBO platformAddGoodsBO = new PlatformAddGoodsBO();
        return platformAddGoodsBO;
    }

}
