package cn.freemud.entities.dto;

import lombok.Builder;
import lombok.Data;

@Data
@Builder
public class UserDeliveryInfoDto {

    /**
     * 用户收货地址经度
     */
    private String userLongitude;
    /**
     * 用户收货地址维度
     */
    private String userLatitude;
    /**
     * 收货人姓名
     */
    private String receiveUserName;
    /**
     * 收货人手机号
     */
    private String receiveMobile;
    /**
     * 收货人地点名称
     */
    private String receiveOfficeName;
    /**
     * 实际收货地址
     */
    private String receiveAddress;
    /**
     * 门店ID
     */
    private String storeId;
    /**
     * 门店名称
     */
    private String storeName;
    /**
     * 是否可配送
     */
    private Boolean userEnableTakeaway;
    /**
     * 实际需要支付配送费
     */
    private Long realDeliveryAmount;
    /**
     * 起送费单位分
     */
    private Long deliveryLimitAmount;

    /**
     * 门店配送信息
     */
    private StoreDeliveryInfoDto storeDeliveryInfoDto;

}
