package cn.freemud.entities.dto.calculate;

import lombok.Data;

@Data
public class ApportionDetails {

    /**
     * 活动code,如果是商品券，优惠券，放券code
     */
    private String activityCode;
    /**
     * 活动类型  ActivityTypeEnum 枚举，不能为空
     */
    private Integer activityType;
    /**
     * 活动名称，如果是商品券，优惠券，放券名称
     */
    private String activityName;
    /**
     * 特价价格 比如限时特价价格
     */
    private Long goodsNowPrice;
    /**
     * 折扣比率 百分比，非必传  有折扣活动
     */
    private Long activityRebate;
    /**
     * 促销类型  交易类促销  商品类促销  ApportionType
     */
    private Integer apportionType;
    /**
     * 活动均摊金额
     */
    private Long activityApportionAmount;

    private Long amount;

}
