package cn.freemud.management.entities.dto.response.pay;

import lombok.Data;

@Data
public class PayRefundData {

    private Integer resultCode;
    private String resultMsg;
    private String thirdPartTradeNo;
    private String tradeNo;
    private String refundTradeNo;
    private String thirdPartRefundTradeNo;
    /**
     * 申请退款金额
     */
    private Long refundAmount;
    private Long totalAmount;
    private Integer refundStatus;
    /**
     * 退款成功时间
     */
    private String refundTime;
    /**
     * 支付渠道编号
     */
    private String payCode;

    /**
     * 支付方式
     * {@link com.freemud.application.sdk.api.ordercenter.enums.PayMethodEnum}
     */
    private String payMethodCode;

    /**
     * 现金类型， 当payMethodCode为其他的时候，存在该值
     * {@link com.freemud.application.sdk.api.ordercenter.enums.CashTypeEnum}
     */
    private String cashType;

    /**
     * 支付条码， 当支付方式为储值卡的时候，该字段为卡号
     */
    private String uniqueCode;
}
