package cn.freemud.management.adapter;

import cn.freemud.base.util.DateUtil;
import cn.freemud.management.entities.dto.request.order.RefundSuccessCallbackVo;
import cn.freemud.management.entities.dto.response.pay.OrderRefundResponse;
import cn.freemud.management.entities.dto.response.pay.PayRefundData;
import cn.freemud.management.entities.dto.response.pay.PayRefundResponse;
import cn.freemud.management.enums.PaymentRefundStatus;
import com.freemud.application.sdk.api.ordercenter.enums.CashTypeEnum;
import com.freemud.application.sdk.api.ordercenter.enums.PayMethodEnum;
import com.freemud.application.sdk.api.ordercenter.request.OrderCancelReq;
import com.freemud.sdk.api.assortment.order.response.order.MultiOrderRefundResponse;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static cn.freemud.management.service.handle.PaymentHandle.*;

/**
 * @author Clover.z
 * @version 1.0.0
 * @since 1.0.0
 */
public class OrderCancelReqAdapter {

    public static List<OrderCancelReq.PayRefundItem> convert(List<PayRefundResponse.PayRefundItem> list) {
        List<OrderCancelReq.PayRefundItem> refundItemList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(item -> {
                OrderCancelReq.PayRefundItem refundItem = new OrderCancelReq.PayRefundItem();
                BeanUtils.copyProperties(item, refundItem);
                refundItemList.add(refundItem);
            });
        }
        return refundItemList;
    }

    public static PayRefundResponse.PayRefundItem convert(OrderRefundResponse orderRefundData) {
        PayRefundResponse.PayRefundItem refundItem = new PayRefundResponse.PayRefundItem();
        if (StringUtils.isNotBlank(orderRefundData.getCashType())) {
            refundItem.setPayChannelType(Integer.valueOf(orderRefundData.getCashType()));
            refundItem.setPayChannelName(CashTypeEnum.getByCode(orderRefundData.getCashType()) == null ? null : CashTypeEnum.getByCode(orderRefundData.getCashType()).getDesc());
        } else {
            refundItem.setPayChannelType(PayMethodEnum.getIndexByCode(orderRefundData.getPayMethodCode()));
            refundItem.setPayChannelName(PayMethodEnum.getDescByCode(orderRefundData.getPayMethodCode()));
        }
        refundItem.setAmount(orderRefundData.getRefundAmount().intValue());
        refundItem.setRefundTradeNo(orderRefundData.getRefundTradeNo());
        refundItem.setRefundTime(DateUtil.convert2Date(orderRefundData.getRefundTime(), "yyyy-MM-dd HH:mm:ss").getTime());
        refundItem.setCardCode(PayMethodEnum.TSVC.getCode().equals(orderRefundData.getPayMethodCode()) ? orderRefundData.getUniqueCode() : null);

        return refundItem;
    }

    public static List<PayRefundResponse.PayRefundItem> convertMultiRefundItem(List<MultiOrderRefundResponse.RefundPlatformResponse> orderRefundList) {
        return orderRefundList.stream()
                .map(r -> {
                    PayRefundResponse.PayRefundItem refundItem = new PayRefundResponse.PayRefundItem();
                    if (StringUtils.isNotBlank(r.getCashType())) {
                        refundItem.setPayChannelType(Integer.valueOf(r.getCashType()));
                        refundItem.setPayChannelName(CashTypeEnum.getByCode(r.getCashType()) == null ? null : CashTypeEnum.getByCode(r.getCashType()).getDesc());
                    } else {
                        refundItem.setPayChannelType(PayMethodEnum.getIndexByCode(r.getPayMethodCode()));
                        refundItem.setPayChannelName(PayMethodEnum.getDescByCode(r.getPayMethodCode()));
                    }
                    refundItem.setAmount(r.getSettleRefundAmount());
                    refundItem.setRefundTradeNo(r.getRefundTradeNo());
                    refundItem.setRefundTime(DateUtil.convert2Date(r.getRefundTime(), "yyyy-MM-dd HH:mm:ss").getTime());
                    refundItem.setCardCode(PayMethodEnum.TSVC.getCode().equals(r.getPayMethodCode()) ? r.getUniqueCode() : null);
                    return refundItem;
                })
                .collect(Collectors.toList());
    }

    public static List<PayRefundResponse.PayRefundItem> convert(RefundSuccessCallbackVo request) {
        List<PayRefundResponse.PayRefundItem> payRefundItemList = Lists.newArrayList();
        PayRefundResponse.PayRefundItem payRefundItem = new PayRefundResponse.PayRefundItem();
        payRefundItem.setRefundTradeNo(request.getRefundTradeNo());
        if (StringUtils.isNotBlank(request.getCashType())) {
            payRefundItem.setPayChannelType(Integer.valueOf(request.getCashType()));
            payRefundItem.setPayChannelName(CashTypeEnum.getByCode(request.getCashType()) == null ? null : CashTypeEnum.getByCode(request.getCashType()).getDesc());
        } else {
            payRefundItem.setPayChannelType(PayMethodEnum.getIndexByCode(request.getPayMethodCode()));
            payRefundItem.setPayChannelName(PayMethodEnum.getDescByCode(request.getPayMethodCode()));
        }
        payRefundItem.setAmount(request.getRefundAmount());
        payRefundItem.setRefundTime(DateUtil.convert2Date(request.getRefundTime(), "yyyy-MM-dd HH:mm:ss").getTime());
        payRefundItem.setCardCode(PayMethodEnum.TSVC.getCode().equals(request.getPayMethodCode()) ? request.getUniqueCode() : null);
        payRefundItemList.add(payRefundItem);

        return payRefundItemList;
    }

    public static OrderRefundResponse convert(PayRefundData refundData) {
        OrderRefundResponse refundResponse = new OrderRefundResponse();
        refundResponse.setStatusCode(refundData.getResultCode());
        refundResponse.setMsg(refundData.getResultMsg());
        refundResponse.setRefundAmount(refundData.getRefundAmount());
        refundResponse.setTotalAmount(refundData.getTotalAmount());
        refundResponse.setRefundStatus(getRefundStatus(refundData.getResultCode()));
        refundResponse.setRefundTradeNo(refundData.getRefundTradeNo());
        refundResponse.setTradeNo(refundData.getRefundTradeNo());
        refundResponse.setThirdPartRefundTradeNo(refundData.getThirdPartRefundTradeNo());
        refundResponse.setThirdPartTradeNo(refundData.getThirdPartTradeNo());
        refundResponse.setTotalAmount(refundData.getTotalAmount());
        refundResponse.setCashType(refundData.getCashType());
        refundResponse.setPayMethodCode(refundData.getPayMethodCode());
        refundResponse.setUniqueCode(refundData.getUniqueCode());
        refundResponse.setRefundTime(refundData.getRefundTime());

        return refundResponse;
    }

    public static Integer getRefundStatus(Integer resultCode) {
        if (Objects.equals(resultCode, SUCCESS_RESPONSE_CODE_INT)) {
            return PaymentRefundStatus.PAYMENT_REFUND_STATUS_1.getCode();
        } else if (Objects.equals(resultCode, SUCCESS_RESPONSE_101_CODE_INT)) {
            return PaymentRefundStatus.PAYMENT_REFUND_STATUS_1.getCode();
        } else {
            return Objects.equals(resultCode, REFUND_RESPONSE_CODE) ? PaymentRefundStatus.PAYMENT_REFUND_STATUS_4.getCode() : PaymentRefundStatus.PAYMENT_REFUND_STATUS_2.getCode();
        }
    }
}
