package cn.freemud.entities.dto.store;


import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: Organization
 * @Package com.freemud.console.dao.entity
 * @Description: (用一句话描述该文件做什么)
 * @author: jsddkj
 * @date: 9/21 0021_14:38
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class StoreResponse {

    @ApiModelProperty(value = "组织编号")
    private String storeId;
    @ApiModelProperty(value = "组织编码")
    private String storeCode;
    @ApiModelProperty(value = "名称")
    private String storeName;
    @ApiModelProperty(value = "名称-英文")
    private String storeNameEn;
    @ApiModelProperty(value = "商户编号")
    private String parentId;
    @ApiModelProperty(value = "商户编码")
    private String parentCode;
    @ApiModelProperty(value = "商户名称")
    private String parentName;
    @ApiModelProperty(value = "父编码")
    private String partnerId;
    @ApiModelProperty(value = "简称")
    private String briefName;
    @ApiModelProperty(value = "经度")
    private String longitude;
    @ApiModelProperty(value = "纬度")
    private String latitude;
    @ApiModelProperty(value = "经纬度geohash")
    private String geohash;
    @ApiModelProperty(value = "营业时间")
    private String businessHours;
    @ApiModelProperty(value = "营业状态")
    private String state;
    @ApiModelProperty(value = "电话")
    private String phone;
    @ApiModelProperty(value = "地址")
    private String address;
    @ApiModelProperty(value = "地址-英文")
    private String addressEn;
    @ApiModelProperty(value = "类型")
    private Integer typeFlag;
    @ApiModelProperty(value = "状态")
    private Integer activeFlag;
    @ApiModelProperty(value = "距离")
    private String distance;
    @ApiModelProperty(value = "排序距离")
    private Double sortDistance;
    @ApiModelProperty(value = "备注")
    private String remark;
    @ApiModelProperty(value = "省")
    private String province;
    @ApiModelProperty(value = "市")
    private String city;
    @ApiModelProperty(value = "区")
    private String region;
    @ApiModelProperty(value = "是否开通下单平台{1.是；2.否}")
    private String placeOrderFlag;
    @ApiModelProperty(value = "是否开通Delivery{1.是；2.否}")
    private String delivery;
    @ApiModelProperty(value = "配送时间")
    private String deliveryHours;
    @ApiModelProperty(value = "配送价格")
    private Double deliveryPrice;
    @ApiModelProperty(value = "配送半径,单位米")
    private Integer deliveryRadius;
    @ApiModelProperty(value = "起送费")
    private Double freeDeliveryPrice;
    @ApiModelProperty(value = "适用标签Id串，半角逗号间隔")
    private String scopeTagIds;
    @ApiModelProperty(value = "适用标签Name串，汉子半角逗号间隔")
    private String scopeTagNames;
    @ApiModelProperty(value = "配送范围")
    private String distributionScope;
    @ApiModelProperty(value = "是否支持发票（1支持，2不支持）")
    private String receiptFlag;
    @ApiModelProperty(value = "当日营业时间")
    private String businessHoursDay;
    @ApiModelProperty(value = "当日外卖营业时间")
    private String deliveryHoursDay;
    @ApiModelProperty(value = "门店是否被收藏")
    private String collection = "0";
    @ApiModelProperty(value = "轮播速率（毫秒）")
    private Integer BannerSpeed;
    @ApiModelProperty(value = "州名称")
    private String zhouName;
    @ApiModelProperty(value = "州编号")
    private String zhouCode;
    @ApiModelProperty(value = "国家编码")
    private String countryCode;
    @ApiModelProperty(value = "国家名称")
    private String countryName;
    @ApiModelProperty(value = "省份编号")
    private String provinceCode;
    @ApiModelProperty(value = "城市编号")
    private String locationCode;
    @ApiModelProperty(value = "区域编号")
    private String regionCode;
    @ApiModelProperty(value = "预计送达时间,单位分钟")
    private Integer serviceTime;
    @ApiModelProperty(value = "配送范围绘制{1：自定义；2：按半径}")
    private String scopeConfig;
    @ApiModelProperty(value = "预订单提醒时间{1:15分钟;2:30分钟;3:45分钟;4:60分钟}")
    private String orderWarnTime;
    @ApiModelProperty(value = "预订单打印时间{1：提醒时打印；2：接单时打印}")
    private String orderPrintConfig;
    @ApiModelProperty(value = "最大接单量,单位笔")
    private Integer maxOrderQuantity;
    @ApiModelProperty("门店联系人")
    private String storeContacts;
    @ApiModelProperty("门店公告")
    private String storeNotice;
    @ApiModelProperty("休息公告")
    private String breakNotice;
    @ApiModelProperty("商品品类")
    private String productCategory;
    @ApiModelProperty("可开票的最小价格")
    private String minPriceForInvoice;
    @ApiModelProperty("发票特殊说明")
    private String invoiceExplain;
    @ApiModelProperty("打包费")
    private String packageCharge;
    @ApiModelProperty("营业时间范围内的预下单设置")
    private String preOrderSetInTime;
    @ApiModelProperty("营业时间范围外的预下单设置")
    private String preOrderSetOutOfTime;
    @ApiModelProperty("是否支持预定")
    private String isBook;
    @ApiModelProperty("门店延迟发配送时间")
    private String delayDeliveryTime;
    @ApiModelProperty("门店json配置")
    private String configuration;
    @ApiModelProperty("是否支持在线退单")
    private String isOnlineReturnOrder;
    @ApiModelProperty("是否支持自动接单")
    private String isAutoTakeOrder;
    @ApiModelProperty("门店logo")
    private String logoUrl;
    @ApiModelProperty("是否营业(1营业2置休)")
    private String isBusinessOpen;
    @ApiModelProperty("营业时间类型(1按天2按周3自定义)")
    private String businessType;
    @ApiModelProperty("配送说明")
    private String deliveryRemark;
    @ApiModelProperty(value = "配送范围实体")
    private StoreDelivery storeDelivery;
    @ApiModelProperty("门店面积，单位m2")
    private String storeSquare;
    @ApiModelProperty("门店属性（1直营店 2加盟店）")
    private Integer storeAttributee;
    @ApiModelProperty("门店分类（1社区店 2仓储店）")
    private Integer storeType;
    @ApiModelProperty("到店自取（1是 2否）")
    private Integer isSelfMention;
    @ApiModelProperty("门店配置 json")
    private JSONObject storeConfig;

    private String purchaseCode;
    private String userId;
    private String deliveryArea;
    private String priceType;

    @ApiModelProperty("门店手机号")
    private String storeMobile;
    @ApiModelProperty("第三方编号")
    private String thirdPartCode;
    @ApiModelProperty("微信appid")
    private String wxAppid;
    @ApiModelProperty("权益卡优惠金额，麦当劳专用")
    private String benefitCardDiscountAmount;
    @ApiModelProperty("门店营运状态")
    private Integer status;
    /**
     * 客服电话
     */
    @ApiModelProperty("客服电话")
    private String customerServicePhone;

    private List<StoreFloor> storeFloorList;
    /**
     * 参与结算（1：是，2：否）
     */
    @ApiModelProperty("参与结算（1：是，2：否）")
    private Integer takePartInSettleAccounts;
    @ApiModelProperty("appid集合")
    private List<String> wxAppids;

    /**
     * 取餐方式（多种方式逗号分割）
     */
    private String specialDiningMethod;
    /**
     * 选择外卖时，展示收货地址是否在配送范围内
     */
    private Boolean deliveryInclude;
    /**
     * 位置编号
     */
    private String locationNumber;
    /**
     * 开店上线时间
     */
    private Date onlineTime;
    /**
     * 是否支持智能取餐柜，0-不支持、1-支持
     */
    private Integer isSupportCabinet;
    /**
     * 餐具收费是否开启1 是 ，2 否 默认否
     */
    private Integer needCutleryFee;

    /**
     * 是否展示优惠(0-不展示; 1-展示)
     */
    @ApiModelProperty("是否展示优惠(0-不展示; 1-展示)")
    private Integer showDiscount;

    /**
     * 门店图片
     */
    private List<String> pictures;

    /**
     * 门店配送信息
     */
    private DeliveryInfo deliveryInfo;

    /**
     * 外卖平台门店聚合码,目前仅coco商户会用到
     */
    private String qrCodeUrl;

    @ApiModelProperty(value="点餐进度条")
    private ProcessBarResponse processBarResponse;

    @Data
    public static class ProcessBarResponse {

        /**
         * 点餐进度条 1 开启 2 关闭
         */
        private Integer status;

        /**
         * 进度条展示的页面列表（点餐页：orderPage，结算页checkoutPage，取餐页takeMealPage）
         */
        private List<String> pageList;

        /**
         * 进度条单量
         */
        private Integer orderNumber;

        /**
         * 进度条颜色
         */
        private List<ProcessBarColorInfo> processBarColorList;

        /**
         * 制作详情开关（1开启，2关闭, 关闭后只展示订单数不展示商品数量）
         */
        private Integer detailStatus;

        /**
         * 商品单位(1杯，2件，3个)
         */
        private Integer productUnit;

    }

    @Data
    public static class ProcessBarColorInfo {

        @ApiModelProperty(value = "进度条开始")
        private Integer start;

        @ApiModelProperty(value = "进度条结束")
        private Integer end;

        @ApiModelProperty(value = "进度条颜色")
        private String color;

    }

    @Override
    public StoreResponse clone() {
        StoreResponse clone = new StoreResponse();
        clone.setStoreMobile(this.storeMobile);
        clone.setThirdPartCode(this.thirdPartCode);


        clone.setStoreId(this.storeId);
        clone.setPartnerId(this.partnerId);
        clone.setParentId(this.parentId);
        clone.setStoreCode(this.storeCode);
        clone.setStoreName(this.storeName);
        clone.setStoreNameEn(this.storeNameEn);
        clone.setBriefName(this.briefName);
        clone.setTypeFlag(this.typeFlag);
        clone.setRemark(this.remark);
        clone.setActiveFlag(this.activeFlag);
        clone.setLongitude(this.longitude);
        clone.setLatitude(this.latitude);
        clone.setBusinessHours(this.businessHours);
        clone.setPhone(this.phone);
        clone.setAddress(this.address);
        clone.setAddressEn(this.addressEn);
        clone.setPurchaseCode(this.purchaseCode);
        clone.setProvince(this.province);
        clone.setCity(this.city);
        clone.setRegion(this.region);
        clone.setUserId(this.userId);
        clone.setDeliveryPrice(this.deliveryPrice);
        clone.setDeliveryRadius(this.deliveryRadius);
        clone.setDeliveryArea(this.deliveryArea);
        clone.setFreeDeliveryPrice(this.freeDeliveryPrice);
        clone.setPlaceOrderFlag(this.placeOrderFlag);
        clone.setState(this.state);
        clone.setScopeTagIds(this.scopeTagIds);
        clone.setScopeTagNames(this.scopeTagNames);
        clone.setDistributionScope(this.distributionScope);
        clone.setDelivery(this.delivery);
        clone.setParentCode(this.parentCode);
        clone.setParentName(this.parentName);
        clone.setDeliveryHours(this.deliveryHours);
        clone.setReceiptFlag(this.receiptFlag);
        clone.setPriceType(this.priceType);
        clone.setDistance(this.distance);
        clone.setBannerSpeed(this.BannerSpeed);
        clone.setBusinessHoursDay(this.businessHoursDay);
        clone.setDeliveryHoursDay(this.deliveryHoursDay);
        clone.setStoreContacts(this.storeContacts);
        clone.setStoreNotice(this.storeNotice);
        clone.setBreakNotice(this.breakNotice);
        clone.setProductCategory(this.productCategory);
        clone.setMinPriceForInvoice(this.minPriceForInvoice);
        clone.setInvoiceExplain(this.invoiceExplain);
        clone.setPackageCharge(this.packageCharge);
        clone.setPreOrderSetInTime(this.preOrderSetInTime);
        clone.setPreOrderSetOutOfTime(this.preOrderSetOutOfTime);
        clone.setIsBook(this.isBook);
        clone.setDelayDeliveryTime(this.delayDeliveryTime);
        clone.setConfiguration(this.configuration);
        clone.setIsOnlineReturnOrder(this.isOnlineReturnOrder);
        clone.setIsAutoTakeOrder(this.isAutoTakeOrder);
        clone.setLogoUrl(this.logoUrl);
        clone.setIsBusinessOpen(this.isBusinessOpen);
        clone.setBusinessType(this.businessType);
        clone.setDeliveryRemark(this.deliveryRemark);
        clone.setStoreAttributee(this.storeAttributee);
        clone.setStoreType(this.storeType);
        clone.setStoreSquare(this.storeSquare);
        clone.setIsSelfMention(this.isSelfMention);
        clone.setOrderPrintConfig(this.orderPrintConfig);
        clone.setMaxOrderQuantity(this.maxOrderQuantity);
        clone.setOrderWarnTime(this.orderWarnTime);
        clone.setScopeConfig(this.scopeConfig);
        clone.setServiceTime(this.serviceTime);

        clone.setZhouCode(this.zhouCode);
        clone.setZhouName(this.zhouName);
        clone.setCountryCode(this.countryCode);
        clone.setCountryName(this.countryName);
        clone.setProvinceCode(this.provinceCode);
        clone.setLocationCode(this.locationCode);
        clone.setRegionCode(this.regionCode);
        clone.setWxAppid(this.wxAppid);
        clone.setBenefitCardDiscountAmount(this.benefitCardDiscountAmount);
        clone.setStatus(this.status);
        clone.setStoreFloorList(this.storeFloorList);
        clone.setCustomerServicePhone(this.customerServicePhone);
        clone.setTakePartInSettleAccounts(this.takePartInSettleAccounts);
        clone.setWxAppids(this.wxAppids);
        clone.setSpecialDiningMethod(this.specialDiningMethod);
        clone.setDeliveryInclude(this.deliveryInclude);
        clone.setIsSupportCabinet(this.isSupportCabinet);
        clone.setSortDistance(this.sortDistance);
        clone.setGeohash(this.geohash);
        clone.setPictures(this.pictures);
        clone.setDeliveryInfo(deliveryInfo);
        clone.setShowDiscount(showDiscount);
        return clone;
    }

}
