package cn.freemud.entities.dto.shoppingCart;

import cn.freemud.entities.dto.OrderProductAddInfo;
import com.alibaba.fastjson.JSON;
import com.freemud.sdk.api.assortment.order.entities.promption.SubtractStockVO;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;


@Data
public class ShoppingCartGoodsDto {

    /**
     * 购物车实际选择商品，包含加价购商品
     */
    List<CartGoodsDetailDto> products;
    /**
     *
     * 原总价
     */
    private Long originalTotalAmount;
    /**
     * 现总价
     */
    private Long totalAmount;
    /**
     * 总折扣价(优惠价)
     */
    private Long totalDiscountAmount;
    /**
     * 包装费
     */
    private Long packageAmount;

    /**
     * 包装费 收费规则　1= 商品级别 2=订单级别
     */
    private Integer packageAmountCollectType;

    /**
     * 积分扣减金额
     */
    private Long scoreReduceAmount;

    /**
     * 抵用积分
     */
    private Long reduceScore;
    /**
     * 第一次使用会员卡需多支付的金额 单位为分
     */
    private Integer memberCardAmount;

    /**
     * 会员卡原价
     */
    private Integer cardOriginalAmount;

    /**
     * 会员卡优惠金额
     */
    private Integer cardDiscountAmount;
    /**
     * 订单享受的促销活动
     */
    List<ActivityDiscountsDto> activityDiscountsDtos;
    /**
     * 活动库存
     */
    private List<SubtractStockVO> stocks;

    /**
     * 配送费
     */
    private Long deliveryAmount;

    /**
     * 减免后配送费
     */
    private Long discountDeliveryAmount;

    /**
     * 满多少额度 减免
     */
    private Long thresholdAmount;

    /**
     * 是否参加满额减免
     */
    @Builder.Default
    private Boolean isDiscountDelivery = false;

    /**
     * 配送费活动号
     *
     */
    private String discountDeliveryActivityCode;


    /**
     * 送集点
     */
    private SendPoint sendPoint;

    /**
     * 麦咖啡-咖啡月卡价格
     */
    private Long payCardFee;

    /**
     * 积分商品活动使用总积分
     */
    private Long totalScore;

    /**
     * 月享卡总优惠金额
     */
    private MonthCardDiscount monthCardDiscount;

    @Data
    public static class CartGoodsDetailDto {
        /**
         * spuId
         */
        private String spuId;

        /**
         * 库存模式,目前该模式只针对套餐商品会起作用
         * 1-使用套餐库存：即套餐库存和套餐中子商品品库存分别存在、互不影响
         * 2-使用联动库存：即套餐商品的库存为套餐库存和套餐中子商品的库存，当用户购买套餐商品时，同时扣减套餐库存和套餐中子商品的库存，当套餐中任一子商品库存为0或套餐商品的库存为0时，该套餐将不能购买
         */
        protected Integer stockMode = 1;

        /**
         * 原有商品类型
         *
         * 溯源: 订单有自己的商品逻辑 无法使用原有字段类型记录处理
         * 该字段,保持和商品服务的商品类型一致
         */
        private Integer originalProductType;


        /**
         * spuId  如果是单品 skuId=spuId
         */
        private String skuId;
        /**
         * 商品的名称
         */
        private String spuName;
        private String spuForeignName;
        /**
         * 如果是单品 skuName=spuName
         */
        private String skuName;
        private String skuForeignName;
        /**
         * 商品行原始价格
         */
        private Long originalPrice;

        //积分商品活动使用总积分
        private Long score;
        /**
         * 商品图片
         */
        private String picture;
        /**
         * 商品的数量
         */
        private Integer qty;
        /**
         * 商品行优惠总金额=数量*单个商品优惠金额
         */
        private Integer totalDiscountAmount;
        /**
         * 是否包含商品券
         */
        private Boolean hasProductCoupon = false;
        /**
         * 商品券code
         */
        private String couponCode;
        /**
         * 1.5.5版本添加
         * 商品参与活动类型(61:买一赠一)
         */
        private Integer activityType;

        /**
         * 1.6.0 版本增加  节点ID
         */
        private String nodeId;
        /**
         * 1.6.0 版本增加 分类名
         */
        private String categoryName;
        private String categoryForeignName;

        /**
         * 套餐--父级商品Id
         */
        private String parentProductId;

        /**
         * 套餐--type:6
         */
        private Integer productType;

        /**
         * 是否是套餐内固定商品
         */
        private Boolean isFixedProduct;
        private Long productGroupId;

        /**
         * 三方商品编号
         */
        private String customerCode;

        /**商品货号**/
        private String productCode;

        /** 商品统计分类编号**/
        private String classificationId;

        private String classificationName;
        private String classificationForeignName;
        /**
         * 是否限制库存
         * 用于创建订单时，是否扣减库存
         */
        private boolean isStockLimit;
        /**
         * 是否餐具商品
         */
        private Integer isTableware = 0;
        /**
         * 拆分前所属序列
         */
        private String splitIndex;
        /**
         * 商品重量
         */
        private Double weight;

        /**
         * 商品行记录
         */
        private Integer sequence;

        /**
         * 商品的单位
         */
        private String unit;

        /**
         * 费率
         */
        private double tax;

        private String taxId;

        /**
         * 加购人ID
         */
        private String userId;

        /**
         * 加购人openId
         */
        private String openId;

        /**
         * 加购人昵称
         */
        private String userName;

        /**
         * 加购人头像
         */
        private String photoUrl;

        /**
         * 加购人包装费
         */
        private Long packPrice;

        /**
         * 购物车行id
         */
        private String cartGoodsUid;
        /**
         * 是否是月享卡商品
         */
        private int isMonthCard = 0;

        /**
         * 月享卡加购信息
         */
        private MonthCardVo monthCardInfo;
        /**
         * 是否是买3赠1券商品
         */
        private int isB3S1Coupon = 0;
        /**
         * 是否使用了买3赠1券
         */
        private int isB3S1CouponGoods = 0;
        /**
         * 买3赠1券信息
         */
        private B3S1CouponGoodsInfoVo b3S1CouponGoodsInfo;
        /**
         * 是否赠品
         */
        private Boolean isSendGoods;

        /**
         * 配料或属性
         */
        private List<CartGoodsDetailDto.CartGoodsExtra> extraList = new ArrayList<>(0);

        /**
         * 配料或属性
         */
        private List<CartGoodsDetailDto.CartGoodsExtra> specialExtra = new ArrayList<>(0);
        /**
         * 商品行享受的促销活动
         */
        List<ActivityDiscountsDto> activityDiscountsDtos;
        /**
         * 套餐子商品
         */
        private List<CartGoodsDetailDto> comboProducts;

        private List<CartGoodsDetailDto> materialList;

        /**
         * 拼单买一赠一标记赠品是那个商品送的 originalGoodsUid
         */
        private String originalGoodsUid;

        private String extInfo;
        /**
         *  【订C，“POS编码”让凌顶那边去匹配商品】 https://www.tapd.cn/43862731/prong/stories/view/1143862731001039549
         */
        private String linkedId;

        @Data
        public final static class CartGoodsExtra {
            /**
             * 属性Id
             */
            private String attributeId;
            /**
             * 属性名
             */
            private String attributeName;
            private String attributeForeignName;
            /**
             * 入机code
             */
            private String specialCode;
        }


        /**
         * 获取extras attributeNames
         */
        public String getAttributeNames() {
            String extras = "";
            String foreignExtras = "";
            if (CollectionUtils.isNotEmpty(this.extraList)) {
                extras = extraList.stream().map(CartGoodsDetailDto.CartGoodsExtra::getAttributeName).collect(Collectors.joining("/"));
                foreignExtras = extraList.stream().map(CartGoodsDetailDto.CartGoodsExtra::getAttributeForeignName).collect(Collectors.joining("/"));
            }
            return JSON.toJSONString(OrderProductAddInfo.builder().attributeNames(extras).attributeForeignNames(foreignExtras).build());
        }

    }

    @Data
    public static class SendPoint{

        private String activityCode;
        private Date endTime;
        private Integer sendPoint;
        private Integer maxNum;
        private Integer validityDateDays;
        private Boolean storeLevel;
        private Integer isContinueExchange;

    }

    @Data
    public static class MonthCardVo {
        /**
         * 卡号
         */
        private String cardNo;
        /**
         * 券号
         */
        private String cardCode;

        /**
         * 月享卡类型：1.月享卡(单商品购买)；2.月享卡(多商品购买)；3.普通月卡
         */
        private Integer type;
    }

    @Data
    public static class MonthCardDiscount {
        /**
         * 月享卡2.0优惠总额
         */
        private Long discountAmount;
        /**
         * 月享卡券号
         */
        private String couponCode;
        /**
         * 券标识
         */
        private String couponLogo;
        /**
         * 优惠标识
         */
        private String discountLogo;
        /**
         * 优惠描述
         */
        private String discountDesc;
    }

    @Data
    @NoArgsConstructor
    public static class B3S1CouponGoodsInfoVo {
        /**
         * 卡号
         */
        private String cardNo;
        /**
         * 券号
         */
        private String cardCode;
        /**
         * 券号
         */
        private Set<String> cardCodeSet;

        private Integer useTimes;

        private int isUseB3S1Coupon = 1;
    }

}
