package com.freemud.sdk.api.assortment.order.constant;

/**
 * @author Clover.z
 * @Date 2021/8/11
 * @Desc
 */
public class OrderRedisKeyConstant {


    /**
     * 订单是否支持退款配置 缓存key
     *  0：商户号
     *  1：小程序appId
     *
     *  value: hash结构
     *      hkey : HashKeyForOrderRefundConfig中定义
     *      具体配置为json字符串
     *  @see HashKeyForOrderRefundConfig
     */
    public static final String ORDER_REFUND_CONFIG = "kgd:order_refund_config_{0}_{1}";
    /**
     * 订单是否支持退款配置 缓存key的value中 hashKey的枚举
     * 对于的值为json字符串
     * @see com.freemud.sdk.api.assortment.order.entities.OrderRefundConfigEntity
     */
    public static class HashKeyForOrderRefundConfig {
        /**
         *  订单类型为堂食单 redis配置的hkey 对于的值为json字符串
         */
        public static final String EAT_IN = "eatInType";
        /**
         *  订单类型为外卖单 redis配置的hkey 对于的值为json字符串
         */
        public static final String TAKE_OUT = "takeOutType";
        /**
         *  订单类型为收银单 redis配置的hkey 对于的值为json字符串
         */
        public static final String CASHIER = "cashierType";
    }


    /**
     * 订单配置 缓存key
     *  0：商户号
     *  1：小程序appId
     *
     *  value: hash结构
     *      hkey : HashKeyForOrderComplainConfig
     *      具体配置为json字符串
     *  @see HashKeyForOrderRefundConfig
     */
    public static final String ORDER_COMPLAIN_KEY = "kgd:order_config_{0}_{1}";
    /**
     * 订单售后信息相关配置hashKey
     */
    public static class HashKeyForOrderComplainConfig {
        /**
         *  订单售后是否可申诉开关
         *  hashKey 对于的值为 open/close
         */
        public static final String ORDER_COMPLAIN_TYPE = "orderComplaintType";
    }


    /**
     *  下单时 支付商品名称redis缓存key，懒加载方式，有效时间为24小时
     *  {0}：商户号
     *
     *  value：hash结构
     *      hashKey：小程序id wxAppId
     *      hashValue： 支付商户名称
     */
    public static final String PARTNER_PAYMENT_PRINCIPAL_NAME = "kgd:order:payment:principalName:{0}";





}
