/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CartGoods
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: song.cai
 * @date: 2018/12/28 16:45
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.entities.vo;

import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.util.Comparator;
import java.util.List;
import java.util.UUID;

@Data
public class CartGoods {
    /**
     * 购物车一行的Id（后台生成）
     */
    private String cartGoodsUid = UUID.randomUUID().toString();
    /**
     * 单规格spuId,多规格skuId
     */
    private String goodsId;
    /**
     * 1.正常商品，2.商品券，3.套餐商品
     */
    private Integer goodsType;
    /**
     * 1:称重菜 或 套餐商品包含称重菜
     */
    private boolean weightType;
    /**
     * 重量
     */
    private Double weight;
    /**
     * 单位
     */
    private String unit;
    /**
     * 商品券code
     */
    private String couponCode;

    private String spuId;
    private String skuId;
    /**
     * 所有属性attributeId的拼接
     */
    private String specProductId;
    /**
     * 购物车一行商品的原单价
     */
    private Long originalPrice;
    /**
     * 购物车一行商品的原单价总金额
     */
    private Long originalAmount;
    //购物车一行小料商品的原总价
    private Long originalMaterialAmount;
    /**
     * 购物车一行商品的包装费
     */
    private Long packPrice;

    /**
     * 购物车一行商品的现总价
     */
    private Long amount;
    /**
     * 购物车一行商品的现单价
     */
    private Long finalPrice;
    /**
     * 小料总金额
     */
    private Long materialAmount;
    /**
     * 购物车一行商品的数量
     */
    private Integer qty;

    /**
     * 参与活动商品数量 前端展示参数
     */
    private Integer activityNumber;
    /**
     * 购物车一行商品的名称
     */
    private String name;

    /**
     * 商品的spuName
     */
    private String spuName;

    /**
     * 商品的skuName
     */
    private String skuName;

    /**
     * 购物车一行商品的副名称
     */
    private String subName;
    /**
     * 商品图片URL
     */
    private String pic;
    /**
     * 配料或属性
     */
    private List<CartGoodsExtra> extra;

    /**
     * 麦咖啡定制属性
     */
    private List<SpecialExtra> specialExtra;

    /**
     * 创建时间（mili）
     */
    private long createTimeMili = System.currentTimeMillis();
    /**
     * 1.5.5版本添加
     * 商品参与活动类型(61:买一赠一)
     */
    private Integer activityType;
    /**
     * 1.6.0 版本增加  节点ID
     */
    private String nodeId;
    /**
     * 1.6.0 版本增加 分类名
     */
    private String categoryName;

    /**
     * 统计分类编号
     */
    private String classificationId;
    /**
     * 统计分类名称
     */
    private String classificationName;
    /**
     * 是否限制库存
     * 用于创建订单时，是否扣减库存
     */
    private boolean isStockLimit;
    /**
     * 第三方商品编码
     */
    private String customerCode;
    /**
     * 商品起售份数
     * 无起售份数默认值1
     */
    private Integer riseSell;
    /**
     * 折扣比例
     * 例如8折为80
     */
    private Integer memberDiscount;

    /**
     * 费率
     */
    private Double tax;

    /**
     * 费率代码
     */
    private String taxId;

    /**
     * 套餐固定商品
     */
    private List<ComboxGoods> productComboList;
    /**
     * 套餐可选商品
     */
    private List<ComboxGoods> productGroupList;

    /**
     * 商品原始加料数据
     */
    private List<MaterialGoods> productMaterialList;

    @Data
    public final static class CartGoodsExtra {
        /**
         * 属性Id
         */
        private String attributeId;
        /**
         * 属性名
         */
        private String attributeName;
    }

    @Data
    public final static class SpecialExtra {
        /**
         * 属性Id
         */
        private String attributeId;
        /**
         * 属性名
         */
        private String attributeName;

        /**
         * 麦咖啡特定属性入机code
         */
        private String specialCode;
    }

    @Data
    public final static class ComboxGoods {
        /**
         * 单规格spuId,多规格skuId
         */
        private String goodsId;
        private String spuId;
        private String skuId;
        private String skuName;
        /**
         * 所有属性attributeId的拼接
         */
        private String specProductId;
        /**
         * 购物车一行商品的原单机
         */
        private Long originalPrice;
        /**
         * 购物车一行商品的现售单价
         */
        private Long finalPrice;

        /**
         * 购物车一行商品的包装费
         */
        private Long packPrice;

        /**
         * 购物车一行商品的原价
         */
        private Long originalAmount;

        /**
         * 购物车一行商品的现价
         */
        private Long amount;
        /**
         * 购物车一行商品的数量
         */
        private Integer qty;
        /**
         * 购物车一行商品的名称
         */
        private String name;

        /**
         * 商品的spuName
         */
        private String spuName;
        /**
         * 购物车一行商品的副名称
         */
        private String subName;
        /**
         * 商品图片URL
         */
        private String pic;
        /**
         * 配料或属性
         */
        private List<CartGoodsExtra> extra;

        /**
         * 麦咖啡特定属性
         */
        private List<SpecialExtra> specialExtra;
        /**
         * 1:称重菜
         */
        private boolean weightType;
        /**
         * 重量
         */
        private Double weight;
        /**
         * 单位
         */
        private String unit;
        /**
         * 第三方商品编号
         */
        private String customerCode;
        /**
         * 商品组Id
         */
        private Long productGroupId;

        /**
         * 费率
         */
        private Double tax;

        /**
         * 费率代码
         */
        private String taxId;
        /**
         * 商品原始加料数据
         */
        private List<MaterialGoods> productMaterialList;

        @Override
        public int hashCode() {
            StringBuilder sb = new StringBuilder();
            sb.append(goodsId);
            if (CollectionUtils.isNotEmpty(extra)) {
                extra.stream().sorted(Comparator.comparing(CartGoodsExtra::getAttributeId)).forEach(e -> sb.append(e.getAttributeId()));
            }
            return sb.toString().hashCode();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(goodsId);
            if (CollectionUtils.isNotEmpty(extra)) {
                extra.stream().sorted(Comparator.comparing(CartGoodsExtra::getAttributeId)).forEach(e -> sb.append(e.getAttributeId()));
            }
            if (CollectionUtils.isNotEmpty(specialExtra)) {
                specialExtra.stream().sorted(Comparator.comparing(SpecialExtra::getAttributeId)).forEach(e -> sb.append(e.getAttributeId()));
            }
            return sb.toString();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;

        // 原始字符串
        StringBuilder originalString = new StringBuilder();
        originalString.append(goodsId);
        originalString.append(couponCode);
        if (CollectionUtils.isNotEmpty(extra)) {
            extra.stream().sorted(Comparator.comparing(CartGoodsExtra::getAttributeId)).forEach(e -> originalString.append(e.getAttributeId()));
        }
        if (CollectionUtils.isNotEmpty(productComboList)) {
            for (ComboxGoods goods : productComboList) {
                originalString.append(goods.toString());
                if (CollectionUtils.isNotEmpty(goods.getSpecialExtra())) {
                    goods.getSpecialExtra().stream().sorted(Comparator.comparing(SpecialExtra::getAttributeId)).forEach(e -> originalString.append(e.getAttributeId()));
                }
            }
        }
        if (CollectionUtils.isNotEmpty(productGroupList)) {
            for (ComboxGoods goods : productGroupList) {
                originalString.append(goods.toString());
            }
        }
        if (CollectionUtils.isNotEmpty(productMaterialList)) {
            productMaterialList.stream().sorted(Comparator.comparing(MaterialGoods::getSpuId)).forEach(e -> originalString.append(e.getSpuId()));
        }
        if (CollectionUtils.isNotEmpty(specialExtra)) {
            specialExtra.stream().sorted(Comparator.comparing(SpecialExtra::getAttributeId)).forEach(e -> originalString.append(e.getAttributeId()));
        }
        //当前字符串
        CartGoods cartGoods = (CartGoods) o;

        StringBuilder currentString = new StringBuilder();
        currentString.append(cartGoods.getGoodsId());
        currentString.append(cartGoods.getCouponCode());
        if (CollectionUtils.isNotEmpty(cartGoods.getExtra())) {
            cartGoods.getExtra().stream().sorted(Comparator.comparing(CartGoodsExtra::getAttributeId)).forEach(e -> currentString.append(e.getAttributeId()));
        }
        if (CollectionUtils.isNotEmpty(cartGoods.getProductComboList())) {
            for (ComboxGoods goods : cartGoods.getProductComboList()) {
                currentString.append(goods.toString());
                if (CollectionUtils.isNotEmpty(goods.getSpecialExtra())) {
                    goods.getSpecialExtra().stream().sorted(Comparator.comparing(SpecialExtra::getAttributeId)).forEach(e -> currentString.append(e.getAttributeId()));
                }
            }
        }
        if (CollectionUtils.isNotEmpty(cartGoods.getProductGroupList())) {
            for (ComboxGoods goods : cartGoods.getProductGroupList()) {
                currentString.append(goods.toString());
            }
        }
        if (CollectionUtils.isNotEmpty(cartGoods.getProductMaterialList())) {
            cartGoods.getProductMaterialList().stream().sorted(Comparator.comparing(MaterialGoods::getSpuId)).forEach(e -> currentString.append(e.getSpuId()));
        }
        if (CollectionUtils.isNotEmpty(cartGoods.getSpecialExtra())) {
            cartGoods.getSpecialExtra().stream().sorted(Comparator.comparing(SpecialExtra::getAttributeId)).forEach(e -> currentString.append(e.getAttributeId()));
        }
        return StringUtils.equals(originalString.toString(), currentString.toString());
    }

    @Override
    public int hashCode() {
        StringBuilder sb = new StringBuilder();
        sb.append(goodsId);
        if (CollectionUtils.isNotEmpty(extra)) {
            extra.stream().sorted(Comparator.comparing(CartGoodsExtra::getAttributeId)).forEach(e -> sb.append(e.getAttributeId()));
        }
        int hashCode = sb.toString().hashCode();
        if (CollectionUtils.isNotEmpty(productComboList)) {
            for (ComboxGoods goods : productComboList) {
                hashCode += goods.hashCode();
            }
        }
        if (CollectionUtils.isNotEmpty(productGroupList)) {
            for (ComboxGoods goods : productGroupList) {
                hashCode += goods.hashCode();
            }
        }
        return hashCode;
    }

    /**
     * 是否为称重菜或套餐中存在称重菜
     * @return
     */
    public boolean hasWeight(){
        boolean hashWeight = this.isWeightType();
        if (!org.springframework.util.CollectionUtils.isEmpty(this.getProductComboList())) {
            long count = this.getProductComboList().stream().filter(CartGoods.ComboxGoods::isWeightType).count();
            hashWeight = hashWeight || count > 0;
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(this.getProductGroupList())) {
            long count = this.getProductGroupList().stream().filter(CartGoods.ComboxGoods::isWeightType).count();
            hashWeight = hashWeight || count > 0;
        }
        return hashWeight;
    }

    @Data
    @NoArgsConstructor
    public static class MaterialGoods {

        /**
         * 加料Id
         */
        private String spuId;
        /**
         * 加料名称
         */
        private String spuName;
        /**
         * 购物车一行商品的原单价
         */
        private Long originalPrice;
        /**
         * 购物车一行商品的原价*数量
         */
        private Long originalAmount;
        /**
         * 购物车一行商品的现售单价
         */
        private Long finalPrice;
        /**
         * 购物车一行商品的现价*数量
         */
        private Long amount;
    }
}
