package com.freemud.application.sdk.api.ordercenter.enums;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OrderSettlementType
 * @Package com.freemud.application.sdk.api.ordercenter.enums
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/2 15:44
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public enum OrderSettlementType {

    OTHER(0, "其他优惠"),
    NEWUSER_FULL_REDUCTION(1, "新用户立减"),
    FULL_REDUCTION(2, "满减"),
    COUPON(3, "抵价券"),
    GIFT_GIVING(4, "套餐赠送"),
    FULL_GIFTS(5, "满赠"),
    OVER_TIME_PAYMENT(6, "超时赔付"),
    PART_FULL_REDUCTION(7, "部分满减"),
    RED_PACKET(9, "使用红包"),
    CASH_COUPON(10, "代金券"),
    ADVANCE(11, "提前下单立减活动"),
    INCREASE_PURCHASE(12, "加价购"),
    FULL_DELIVERY_FEE(16, "满免配送费"),
    ITEM_DISCOUNT(20, "单品折扣"),
    BUY_GIFT(23,"买赠"),
    TAKEAWAY_ADD_PRICE(46, "外卖加价购"),
    PRODUCT_COUPON(118, "商品券"),
    SVC(19, "SVC"),

    POINTS(200, "积分"),
    DISCOUNT(201, "折扣"),
    CASH(202,"现金"),
    WEIXIN(203,"微信"),
    ALIPAY(204,"支付宝"),
    DISCOUNT_FEE(205, "优惠总金额"),
    ITEM_SPECIAL_PRICE(206, "单品特价"),
    ONE_BY_ONE(207, "买一送一"),
    DISCOUNT_COUPON(208, "折扣券"),
    FULL_DISTRIBUTION_FEE(1014, "满减配送费"),
    ;
    private int index;
    private String name;

    public int getIndex() {
        return index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    OrderSettlementType(int index, String name) {
        this.index = index;
        this.name = name;
    }
}
