package cn.freemud.enums;

/**
 * 状态码
 *
 * @author liming.guo
 * @date 2018/05/10
 */
public enum ResponseResult {
    /**
     * 通用信息返回
     */
    SUCCESS("100", "ok"),
    SYSTEM_ERROR("50001", "系统内部错误"),
    SYSTEM_BUSINESS_ERROR("50002", "系统业务错误"),
    NOT_LOGIN("40001", "用户未登录"),
    PARAMETER_MISSING("40002", "缺少必要参数"),
    OPERATE_TOO_OFTEN("40003", "忙不过来了，请稍后再试"),
    NOT_SUPPORTED("40004", "操作不支持"),

    /**
     * 用户信息状态码
     */
    SESSION_INVAILD("41000", "用户sessionId已过期"),
    USER_GETPHONE_ERROR("41002", "获取用户手机号失败"),
    USER_SIGNATURE_ERROR("41003", "签名信息错误"),
    USER_REGISTER_ERROR("41004", "用户注册失败"),
    USER_CODE_INVAILD("41005", "无效的code信息"),
    USER_EDIT_MOBILE_ERROR("41007", "修改手机号错误"),
    USER_GETRECEIVEADDRESS_ERROR("41008", "获取收货地址异常"),
    USER_UPDATERECEIVEADDRESS_ERROR("41009", "修改收货地址异常"),
    USER_ADDRECEIVEADDRESS_ERROR("41010", "新增收货地址异常"),
    USER_DELETERECEIVEADDRESS_ERROR("41011", "删除收货地址异常"),
    USER_SVC_CARD_ERROR("41012", "储值卡异常"),
    USER_SVC_CARD_AMOUNT_DEFICIENCY("41013", "储值卡余额不足"),


    /**
     * 验证码 状态码
     */
    SMSCODE_SEND_ERROR("42001", "验证码发送失败"),
    SMSCODE_EXIST("42002", "验证码已发送，请注意查收"),
    SMSCODE_ERROR("42003", "验证码错误，请核对后重新输入"),

    /**
     * 门店状态码
     */
    STORE_IMG_NOT_FOUND("43001", "查询图片数据不存在"),
    STORE_ITEM_QUERY_ERROR("43002", "查询门店商品信息失败"),
    STORE_ITEM_NOT_FOUND("43003", "门店商品信息不存在"),
    STORE_NOT_FOUND("43004", "门店不存在"),
    STORE_ITEM_CHECK_VAILD_ERROR("43005", "门店商品校验失败"),
    STORE_ITEM_CHECK_INVAILD("43006", "商品无效"),
    STORE_ITEM_CHECK_DISCOUNT_CHANGE("43010", "商品限购活动已变更"),
    STORE_ITEM_CHECK_CLOSE("43007", "门店已打烊"),
    STORE_ITEM_STOP_BUSINESS("43010", "门店已停业"),
    STORE_ITEM_NOT_DELIVERY("43008", "门店不支持外卖配送"),
    STORE_ITEM_NOT_IN_DELIVERY_LIMIT_AMOUNT("43009", "订单金额未满足门店起送费"),
    STORE_BUSINESS_HOUR_ERROR("43010", "门店营业时间错误"),
    STORE_NOT_ENABLE_COLLECT_GOODS("43011", "门店不支持到店"),
    STORE_MALL_NOT_FOUND("43012", "商城门店不存在"),
    STORE_DELIVERY_AMOUNT_ERROR("43013", "配送费错误"),
    //麦咖啡专用提示
    CART_STORE_CLOSE("43014","您选择的【$storeName】门店已关闭，请选择其他门店。"),
    CART_STORE_REST("43015","您选择的【$storeName】门店已打烊，请选择其他门店。"),

    /**
     * 购物车状态码
     */
    SHOPPING_CART_GETINFO_ERROR("44001", "查询购物车信息失败"),
    SHOPPING_CART_GETINFO_INVAILD("44002", "购物车信息不存在"),
    SHOPPING_CART_ADD_ERROR("44003", "添加购物车失败"),
    SHOPPING_CART_ADD_INVAILD("44004", "购物车商品不能为空"),
    SHOPPING_CART_UPDATE_ERROR("44005", "更新购物车失败"),
    SHOPPING_CART_CLEAR_ERROR("44006", "清空购车失败"),
    SHOPPING_CART_ACTIVITY_CHANGE("44007", "商品价格有变动，将按照最新活动价格计算哦"),
    SHOPPING_CART_ACTIVITY_UNDERSTOCK("44008", "特价商品库存不足超出部分按照原价购买"),
    SHOPPING_CART_ATTRIBUTE_NOT_EXISTS("44009", "商品属性不存在"),
    SHOPPING_CART_COUPON_NOT_EXIST("44010", "商品券不存在"),
    SHOPPING_CART_SENDGOODS_NOT_EXIST("44011", "加价购商品不存在"),
    SHOPPING_CART_STOCK_NOT_HAVE("44012", "商品库存不足"),
    SHOPPING_CART_VERSION_ERROR("44013", "购物车商品有变动，请手动刷新再修改"),
    SHOPPING_CART_NO_BIND_TABLE_NUMBER("44014", "没有绑定桌号，无法加入购物车"),
    SHOPPING_CART_ORDERING("44015", "有其他小伙伴正在下单，请稍后下单"),
    SHOPPING_CART_PRODUCT_NOT_EXIST("44016", "商品不存在"),
    SHOPPING_CART_REQUIRED_PRODUCT_NOT_EXIST("44017", "必选商品不存在"),
    SHOPPING_CART_GIFTS_PRODUCT_NOT_EXIST("44018", "买赠商品不存在"),
    SHOPPING_CART_SHOP_ID_NOT_EMPTY("44019", "门店编号不能为空"),
    SHOPPING_CART_COUPON_CAN_NOT_USE_THIS_SHOP("44020", "券不适用于该门店"),
    SHOPPING_CART_SEAT_EMPTY("44020", "键位为空"),
    SHOPPING_CART_COUPON_USED("44021", "优惠券已加入餐盘"),
    SHOPPING_CART_GOODS_COUPON_CAN_NOT_USE("44022", "已加入同样优惠券，第二张暂不可用"),
    SHOPPING_CART_PRODUCT_CAN_NOT_USE("44023", "商品不可用"),
    SHOPPING_CART_COUPON_CAN_NOT_USE("44024", "商品券不可用"),
    SHOPPING_CART_HG_COUPON_NOT_EXIST("44027", "换购券不存在"),
    SHOPPING_CART_LIMIT_ADD("44025", "加购数量超过限制"),
    SHOPPING_CART_GOODS_CHECK_ERROR("44028", "当前餐盘中没有可用券的饮品"),
    SHOPPING_CART_NO_MEAL("44029", "无固定搭配套餐请至少选择一个可选商品"),
    SHOPPING_CART_COUPON_MIX_NOT_EXIST("44030", "券商品不存在"),
    SHOPPING_CART_COUPON_NOT_USE("44031", "优惠券不可用"),

    /**
     * 订单状态码
     */
    ORDER_CREATE_ERROR("45001", "订单创建失败"),
    ORDER_PAYACCESS_ERROR("45002", "订单支付成功确认失败"),
    ORDER_QUERYORDER_ERROR("45003", "查询订单失败"),
    ORDER_DELETE_ERROR("45004", "删除订单失败"),
    ORDER__ERRORREFUND("45005", "订单申请退款失败"),
    ORDER_PAY_GETPRE_MESSAGE_ERROR("45006", "获取预支付信息失败"),
    ORDER_EDIT_ERROR("45007", "修改订单错误"),
    ORDER_COPY_ERROR("45008", "订单复制失败"),
    ORDER_CANCEL_ERROR("45009", "取消订单失败"),
    ORDER_QUERY_QUEUE_INDEX_ERROR("45010", "查询订单排队号失败"),
    ORDER_TAKEMEALTIME_INVAILD("45011", "你的取餐时间穿越了，请重新选择！"),
    ORDER_TAKE_OUT_ADDRESS_INVAILD("45012", "外卖配送地址无效"),
    ORDER_TAKE_OUT_ADDRESS_NOT_DELIVERY("45013", "收货地址超过配送范围"),
    ORDER_QUERY_QUANTITYR_ERROR("45014", "获取当前门店制作中订单失败"),
    ORDER_CREATE_VERIFICATION_ERROR("45015", "限时特价商品核销失败"),
    ORDER_CREATE_TAKEMEALTIME_ERROR("45016", "取餐时间不正确"),
    ORDER_CREATE_TIME_NOT_DELIVERY("45017", "不在外卖配送时间范围内"),
    ORDER_CREATE_FORMID_ISNULL("45018", "0元购formId不能为空"),
    ORDER_GET_PAY_EB_CODE_ERROR("45019", "没有配置支付payEbCode"),
    ORDER_WXAPP_NOT_ENABLE_COLLECT_GOODS("45020", "小程序未开通到店自取"),

    /**
     * 优惠券活动
     */
    COUPON_QUERY_ERROR("46001", "获取优惠券信息失败"),
    COUPON_FULL_ACTIVITY_ERROR("46009", "获取满减信息失败"),
    COUPON_GETINFO_INVAILD("46002", "优惠券信息不存在"),
    COUPON_NOT_REACH_CONDITION("46003", "不满足券的指定消费金额"),
    ACTIVITY_NOT_EXIST("46004", "错过是最美好的相遇！您访问的活动不存在"),
    ACTIVITY_QUERY_ERROR("46005", "活动查询失败"),
    COUPON_GET_ERROR("46006", "优惠券领取失败"),
    ACTIVITY_JOIN_FAIL("46007", "参加活动失败"),
    COUPON_NOT_SHARED("46008", "券不可与其他活动同享"),
    COUPON_NOT_ADD_WEIXIN_CARD("46009", "该优化券不能加入微信卡包"),
    COUPON_SHOP_NOTSUPPORT("46010", "优惠券在当前门店不可用"),
    COUPON_ORDER_WAY_ERROR("46011", "您选择得优惠券不适用该点餐方式"),
    COUPON_VERIFICATION_FAIL("46012", "优惠券核销失败"),
    /**
     * 加价购商品
     */
    PREMIUM_EXCHANGE_ACTIVITY_NOT_EXIST("47001", "换购商品已失效啦，请重新下单"),
    PREMIUM_EXCHANGE_SKU_DEFICIENCY("47002", "您选择的换购商品库存不足，请重新下单"),
    PREMIUM_EXCHANGE_GOODS_OUT_OF_LIMIT("47003", "您选择的换购商品总数量大于可换购总数量"),
    PREMIUM_EXCHANGE_ACTIVITY_NOT_ON_LINE("47004", "换购商品不在售卖状态，请重新下单"),

    /**
     * 微信卡券
     */
    WEICHAT_SHOP_NOTSUPPORT("48001", "当前门店不可用"),
    WEICHAT_NOT_PRODUCTCARD("48002", "不是商品券不用加入购物车"),
    WEICHAT_PRODUCT_NOEXIST("48003", "商品不存在");


    private String code;
    private String message;

    /**
     * @param code    状态码
     * @param message 提示信息
     */
    ResponseResult(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
