package cn.freemud.core.db;

import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

import javax.sql.DataSource;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CouponDataSourcesConfig
 * @Package com.freemud.data.source.config
 * @Description:
 * @author: chaopeng.lv
 * @date: 2018/5/16 17:08
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@AutoConfigureBefore(DataSourceAutoConfiguration.class)
@EnableConfigurationProperties({DataSourcesProperties.class})
public class DataSourcesConfig {

    /**
     * 配置数据源
     *
     * @return
     */
    @Bean("dataSource")
    public DataSource dataSource(DataSourcesProperties dataSourcesProperties) {
        return DataSourceBuildUtil.init(dataSourcesProperties);
    }

}
