package cn.freemud.management.service.adapter;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.entities.dto.response.order.OrderManagerResponse;
import cn.freemud.management.enums.ResponseResult;
import cn.freemud.management.service.OrderBaseService;
import cn.freemud.management.service.impl.OrderVerifyService;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrderManagerAdapter {

    @Autowired
    private OrderVerifyService orderVerifyService;
    @Autowired
    private OrderBaseService orderBaseService;
    @Autowired
    private OrderBeanFactory orderBeanFactory;


    /**
     * 接单
     *
     * @param request
     * @return
     */
    public BaseResponse<OrderManagerResponse> orderConfirmTake(OrderManagerRequest request) {
        //查询订单
        QueryOrdersResponse.DataBean.OrderBean orderBean = orderBaseService.getByOrderCode(request.getOrderId());
        //订单接单参数校验
        BaseResponse verifyResponse = orderVerifyService.orderConfirmTakeVerify(orderBean, request);
        if (ObjectUtils.notEqual(verifyResponse.getCode(), ResponseResult.SUCCESS.getCode())) {
            return verifyResponse;
        }
        return orderBeanFactory.getOrderManagerService(orderBean).orderConfirm(request, orderBean);
    }

    /**
     * 拒单
     * @param request
     * @return
     */
    public BaseResponse orderReject(OrderManagerRequest request) {
        return null;
    }

}
