package cn.freemud.service.adapter;

import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;

import java.util.Objects;
public abstract class AbstractOrderCheck implements OrderCheck {
    /**
     * 校验门店状态
     * @param bizVO
     */
    void doStoreStateCheck(StoreResponse.BizVO bizVO) {
        // 校验门店是否停业 1 营业 2 停业 3 繁忙置休
        if (!Objects.equals(bizVO.getState(), "1")) {
            throw new ServiceException(ResponseResult.STORE_MAKE_AN_APPOINTMENT_STOP_BUSINESS);
            // 营业
        } else {
            throw new ServiceException(ResponseResult.STORE_MAKE_AN_APPOINTMENT_OPEN_BUSINESS);
        }
    }

}
