package cn.freemud.enums;

/**
 * 状态码
 *
 * @author liming.guo
 * @date 2018/05/10
 */
public enum ResponseResult {
    /**
     * 通用信息返回
     */
    SUCCESS("100", "ok",""),
    SYSTEM_ERROR("50001", "系统内部错误","System internal error"),
    SYSTEM_BUSINESS_ERROR("50002", "系统业务错误","System business error"),
    NOT_LOGIN("40001", "用户未登录","User not logged in"),
    PARAMETER_MISSING("40002", "缺少必要参数","Missing required parameter"),
    OPERATE_TOO_OFTEN("40003", "忙不过来了，请稍后再试","The system is busy, please try again later"),
    LOGIN_STORE_ERROR("40004", "登录门店异常","Login store exception"),

    /**
     * 用户信息状态码
     */
    SESSION_INVAILD("41000", "用户sessionId已过期",""),
    USER_GETPHONE_ERROR("41002", "获取用户手机号失败",""),
    USER_SIGNATURE_ERROR("41003", "签名信息错误",""),
    USER_REGISTER_ERROR("41004", "用户注册失败",""),
    USER_CODE_INVAILD("41005", "无效的code信息",""),
    USER_EDIT_MOBILE_ERROR("41007", "修改手机号错误",""),
    USER_GETRECEIVEADDRESS_ERROR("41008", "获取收货地址异常",""),
    USER_UPDATERECEIVEADDRESS_ERROR("41009", "修改收货地址异常",""),
    USER_ADDRECEIVEADDRESS_ERROR("41010", "新增收货地址异常",""),
    USER_DELETERECEIVEADDRESS_ERROR("41011", "删除收货地址异常",""),
    USER_SVC_CARD_ERROR("41012", "用户卡号异常",""),
    USER_SVC_CARD_AMOUNT_DEFICIENCY("41013", "储值卡余额不足",""),

    /**
     * 验证码 状态码
     */
    SMSCODE_SEND_ERROR("42001", "验证码发送失败",""),
    SMSCODE_EXIST("42002", "验证码已发送，请注意查收",""),
    SMSCODE_ERROR("42003", "验证码错误，请核对后重新输入",""),

    /**
     * 门店状态码
     */
    STORE_IMG_NOT_FOUND("43001", "查询图片数据不存在",""),
    STORE_ITEM_QUERY_ERROR("43002", "查询门店商品信息失败",""),
    STORE_ITEM_NOT_FOUND("43003", "门店商品信息不存在","Store product information does not exist"),
    STORE_NOT_FOUND("43004", "门店不存在","Store does not exist"),
    STORE_ITEM_CHECK_VAILD_ERROR("43005", "门店商品校验失败","Store product verification failed"),
    STORE_ITEM_CHECK_INVAILD("43006", "商品无效",""),
    STORE_ITEM_CHECK_DISCOUNT_CHANGE("43010", "商品限购活动已变更",""),
    STORE_ITEM_CHECK_CLOSE("43007", "门店已打烊,请预约点餐",""),
    STORE_ITEM_STOP_BUSINESS("43010", "门店已停业","The store is closed"),
    STORE_ITEM_NOT_DELIVERY("43008", "门店不支持外卖配送",""),
    STORE_ITEM_NOT_IN_DELIVERY_LIMIT_AMOUNT("43009", "订单金额未满足门店起送费",""),
    STORE_BUSINESS_HOUR_ERROR("43010", "门店营业时间错误",""),
    STORE_NOT_ENABLE_COLLECT_GOODS("43011", "门店不支持到店",""),
    STORE_NOT_TABLE_INFO("43012", "查询桌号失败","Failed to query table number"),
    STORE_DISCONTENT_DELIVERY_FEE("43013", "不满足起送金额",""),
    STORE_BIND_MALL_NOT_FOUND("43014", "商城门店存在",""),
    STORE_DISCONTENT_DELIVERY_CONDITION("43015", "门店起送条件设置错误",""),
    STORE_DISCONTENT_DELIVERY_CUP("43016", "不满足起送杯数",""),
    STORE_MAKE_AN_APPOINTMENT_STOP_BUSINESS("43017", "预约失败,请重新下单",""),
    STORE_MAKE_AN_APPOINTMENT_OPEN_BUSINESS("43018", "门店不支持预约,请重新选择",""),
    STORE_CLOSED_FOREVER("43017", "门店已关闭，请选择其他门店",""),
    STORE_CLOSED_THE_NIGHT("43018", "门店已打烊，请选择其他门店",""),
    STORE_DELIVERY_HOUR_ERROR("43019", "门店外卖时间错误",""),
    STORE_WILL_COLSE("43020", "门店即将打烊，不能下单",""),
    STORE_DDELIVERY_METHOD("43021", "获取门店外卖配送方式异常",""),
    STORE_QUERYEXPECTARRIVETIME("43022", "获取门店计算预计送达时间失败",""),
    STORE_DATE_ERROR("43023", "门店数据错误",""),

    /**
     * 购物车状态码
     */
    SHOPPING_CART_GETINFO_ERROR("44001", "查询购物车信息失败","Failed to query shopping cart information"),
    SHOPPING_CART_GETINFO_INVAILD("44002", "购物车信息不存在","Shopping cart information does not exist"),
    SHOPPING_CART_ADD_ERROR("44003", "添加购物车失败","Failed to add shopping cart"),
    SHOPPING_CART_ADD_INVAILD("44004", "购物车商品不能为空",""),
    SHOPPING_CART_UPDATE_ERROR("44005", "更新购物车失败",""),
    SHOPPING_CART_CLEAR_ERROR("44006", "清空购车失败",""),
    SHOPPING_CART_ACTIVITY_CHANGE("44007", "商品价格有变动，将按照最新活动价格计算哦",""),
    SHOPPING_CART_ACTIVITY_UNDERSTOCK("44008", "特价商品库存不足超出部分按照原价购买",""),
    SHOPPING_CART_ATTRIBUTE_NOT_EXISTS("44009", "商品属性不存在",""),
    SHOPPING_CART_COUPON_NOT_EXIST("44010", "商品券不存在",""),
    SHOPPING_CART_SENDGOODS_NOT_EXIST("44011", "加价购商品不存在",""),
    SHOPPING_CART_STOCK_NOT_HAVE("44012", "商品库存不足",""),
    SHOPPING_CART_PRODUCT_NOT_EXIST("44013", "商品不存在",""),

    /**
     * 订单状态码
     */
    ORDER_CREATE_ERROR("45001", "订单创建失败",""),
    ORDER_PAYACCESS_ERROR("45002", "订单支付成功确认失败",""),
    ORDER_QUERYORDER_ERROR("45003", "查询订单失败","Order query failed"),
    ORDER_DELETE_ERROR("45004", "删除订单失败",""),
    ORDER__ERRORREFUND("45005", "订单申请退款失败",""),
    ORDER_PAY_GETPRE_MESSAGE_ERROR("45006", "获取预支付信息失败","Failed to get advance payment information"),
    ORDER_EDIT_ERROR("45007", "修改订单错误","Error modifying order"),
    ORDER_COPY_ERROR("45008", "订单复制失败",""),
    ORDER_CANCEL_ERROR("45009", "取消订单失败",""),
    ORDER_QUERY_QUEUE_INDEX_ERROR("45010", "查询订单排队号失败",""),
    ORDER_TAKEMEALTIME_INVAILD("45011", "你的取餐时间穿越了，请重新选择！",""),
    ORDER_TAKE_OUT_ADDRESS_INVAILD("45012", "外卖配送地址无效",""),
    ORDER_TAKE_OUT_ADDRESS_NOT_DELIVERY("45013", "收货地址超过配送范围",""),
    ORDER_QUERY_QUANTITYR_ERROR("45014", "获取当前门店制作中订单失败",""),
    ORDER_CREATE_VERIFICATION_ERROR("45015", "限时特价商品核销失败",""),
    ORDER_CREATE_TAKEMEALTIME_ERROR("45016", "取餐时间不正确",""),
    ORDER_CREATE_TIME_NOT_DELIVERY("45017", "不在外卖配送时间范围内",""),
    ORDER_CREATE_FORMID_ISNULL("45018", "0元购formId不能为空",""),
    ORDER_GET_PAY_EB_CODE_ERROR("45019", "没有配置支付payEbCode",""),
    ORDER_WXAPP_NOT_ENABLE_COLLECT_GOODS("45020","小程序未开通到店自取",""),
    PAY_AMOUNT_ERROR("45021","订单支付金额不能小于0",""),
    ORDER_NOT_EXIST("45022","订单不存在",""),
    ORDER_HAD_EVALUATE("45023","订单已评价",""),
    ENCIRCLEORDER_TABLENUMBER_LOCK_ERROR("45025","调用基础服务清台失败",""),
    ENCIRCLEORDER_TABLENUMBER_LOCK_USERINFO_ERROR("45026","开台获取用户信息失败",""),
    ENCIRCLEORDER_TABLENUMBER_LOCK_FAILED("45027","开台失败","Table Opening failed"),
    ENCIRCLEORDER_PRE_PAYMENT_LOCK("45028","你的订单正在下单支付,无需再支付,请查看","Your order is being placed for payment. No further payment is required. Please check"),
    //ENCIRCLEORDER_PRE_PAYMENT_SUCCESS("45028","订单已支付",""),
    ENCIRCLEORDER_PRE_PAYMENT_CLOSE_FAILED("45029","关闭预支付订单失败",""),
    ENCIRCLEORDER_UPDATE_ORDER_LOCK("45030","有小伙伴正在下单，请稍后下单","There is a small partner placing an order, please place an order later"),
    ORDER_COMPAR_PRODUCTS_CHANGE("45031", "订单价格变动,总金额:￥ ",""),
    CALL_STORE_CHANGE_TABLENUMBER_ERROR("45032","调用门店服务修改桌号状态失败","Failed to call store service to modify table number status"),
    QUERY_STORE_TABLEWARE_ERROR("45033","查询门店服务餐具错误","Query store service error"),
    CREATE_GROUP_ORDER_ERROR_START("45034","围餐开台创建订单失败","Failed to create order for round table opening"),
    ORDER_CREATE_OPERATION_ERROR("45035","操作类型未定义","The operation type is undefined"),
    ORDER_INFO_NOT_WEIGHT_ERROR("45036","订单中包含未称重商品","The order contains unweighted items"),
    ORDER_CODE_EMPTY("45037","订单号不能传空",""),
    CREATE_ORDER_CHECK_SESSION_ERROR("45037","sessionId 不能为空",""),
    CREATE_ORDER_CHECK_STORE_ERROR("45038","门店ID 不能为空",""),
    CREATE_ORDER_CHECK_ORDERTYPE_ERROR("45039","下单类型不能为空",""),
    ORDER_PRE_PAYMENT_LOCK("45040","订单正在支付","The order is being paid"),
    ORDER_NOT_ALLOW_REFUND("45100", "退款失败，请和店员伙伴约定线下退款",""),
    QUERY_TABLESTATUS_ACTIVEFLAG_ERROR("45041","桌号禁用","Table number forbidden"),
    PREVIEWORDER_UPDATE_ORDERPRICE_ERROR("45042","修改订单失败","Failed to modify order"),
    UPDATE_ORDER_INFO_ERROR("45043","下单失败","Order failed"),
    CLEAR_SHOPPING_INFO_ERROR("45044","操作购物车失败","Failed to operate shopping cart"),
    ORDER_CREATE_TABLE_ERROR("45046","开台异常","Abnormal opening"),
    ORDER_TABLE_BINDING_ERROR("45047","用户未绑定桌号","The user is not bound with the table number"),//改code与前端有强关联，不可重复
    ENCIRCLEORDER_TABLENUMBER_LOCK("45048","当前桌号正在开台或已开台","The current table number is being opened or has been opened"),
    ENCIRCLEORDER_PRE_PAYMENT_SUCCESS("45049","订单已支付","Order paid"),
    CLEAR_SHOPPING_INFO_SYSTEM_ERROR("45048","清空购物车异常","Empty shopping cart abnormal"),
    ORDER_PARTNER_ID_NOT_MATCTH("45050","商户不匹配",""),
    ORDER_STORE_ID_NOT_MATCTH("45051","门店不匹配",""),
    ORDER_REPEAT_DO_COMPLETE("45052", "重复操作，订单已经完成",""),
    ORDER_HAS_CANCELED("45053", "订单已经被取消",""),
    ORDER_MALL_NOT_MATCH("45054", "非商城订单，无法操作",""),
    AFFIRM_ORDER_FAIL("45055", "确认订单失败",""),
    ORDER_EMPTY_CREATE_PREPAY_FAIL("45056", "订单为空，创建预订单失败",""),
    ORDER_HAS_PAID("45057", "订单已支付或已完成",""),
    ORDER_PRE_PAYMENT_CLOSE_FAILED("45058","关闭预支付订单失败","Failed to close prepayment order"),
    ORDER_OWNER_ERROR("45059","订单归属错误",""),
    ORDER_STATUS_PRE_PAYMENT_NOT_SUPPORT("45060", "订单非待支付状态, 创建预支付失败",""),
    ORDER_TAKEMEALTIME_INVALID("45061", "你的隔日预约时间有误，请重新刷新后选择！",""),
    ORDER_CONVERT_ERROR("45062", "查询订单结果转换失败",""),
    ORDER_NO_PAU("45063", "订单未支付",""),
    ORDER_DELIVERY_CALL_BACK_FAILED("45083", "配送回调失败，为找到对应操作类型",""),
    ORDER_COLLECT_FAILED("45084", "推送入机失败,配送回调失败",""),
    ORDER_TAKE_MEAL_TIME_ERROR("450062", "你的到店取餐时间异常，请重新选择！",""),
    ORDER_MEALTIME_MISSING("450063", "你的取餐方式或取餐时间异常，请重新选择!",""),
    ORDER_TAKE_OUT_TIME_ERROR("450062", "你的外卖送达时间异常，请重新选择！",""),
    ORDER_TAKE_OUT_ADDRESS_NOT_VALID("45063", "收货地址校验失败",""),
    ORDER_PICK_UP_GOOD_NO("45064", "更新取餐码失败",""),
    ORDER_NOT_CREATE_ERROR("45065", "请不要重复创建订单",""),
    MULTIORDER__ERRORREFUND("45005", "订单申请退款失败",""),
    ORDER_GROUP_BUY_LIST_EMPTY("45069", "付款人列表为空，无法发起群收款",""),
    COLLAGE_ORDER_CREATE_ERROR_NOT_EXIST("45070", "拼单信息不存在，无法创建订单",""),
    COLLAGE_ORDER_CREATE_ERROR_PAYING("45071", "拼单正在支付，请勿重复提交",""),
    COLLAGE_ORDER_CREATE_ERROR_PAYED("45072", "拼单已支付完成，请返回订单列表查看",""),
    ORDER_CANCEL_ERROR_EXPECT_TIME("45067", "预约时间还剩15分钟，无法取消",""),
    ORDER_CANCEL_ERROR_ESTIMATE_TIME("45068", "预计送达还剩30分钟，无法取消",""),
    STORE_SELF_ERROR("45069", "请选择截止营业时间大于45分钟下单",""),
    COUPON_INVALID("45070", "券已锁定，请先支付或取消待支付订单",""),
    ORDER_RECEIVE_ERR("45071", "确认收货失败，请稍后再试",""),

    /**
     * 售后单
     */
    ORDER_REFUND_EXPRESS_ERROR("45200", "售后单修改物流信息失败",""),

    /**
     * 支付
     */
    PAY_BACKEND_CONFIG_ERROR("58003", "支付交易异常","Abnormal payment transaction"),
    /**
     * 优惠券活动
     */
    COUPON_QUERY_ERROR("46001", "获取优惠券信息失败",""),
    COUPON_FULL_ACTIVITY_ERROR("46009", "获取满减信息失败",""),
    COUPON_GETINFO_INVAILD("46002", "优惠券信息不存在",""),
    COUPON_NOT_REACH_CONDITION("46003", "不满足券的指定消费金额",""),
    ACTIVITY_NOT_EXIST("46004", "错过是最美好的相遇！您访问的活动不存在",""),
    ACTIVITY_QUERY_ERROR("46005", "活动查询失败",""),
    COUPON_GET_ERROR("46006", "优惠券领取失败",""),
    ACTIVITY_JOIN_FAIL("46007", "参加活动失败",""),
    COUPON_NOT_SHARED("46008", "券不可与其他活动同享",""),
    COUPON_NOT_ADD_WEIXIN_CARD("46009", "该优化券不能加入微信卡包",""),
    COUPON_SHOP_NOTSUPPORT("46010","优惠券在当前门店不可用",""),
    COUPON_ORDER_WAY_ERROR("46011", "您选择得优惠券不适用该点餐方式",""),
    COUPON_VERIFICATION_FAIL("46012","优惠券核销失败",""),
    COUPON_CALLBACK_FAIL("46013","优惠券移除卡包失败",""),
    COUPON_INVAILD("46014", "优惠券失效",""),
    COUPON_TYPE_ERROR("46015","优惠类型错误",""),
    PAY_ERROR("46016","支付类型错误",""),
    COUPON_DATETIME_INVAILD("46017", "优惠券在当前时间不可用",""),
    COUPON_ORDER_ORIGINAL_AMOUNT_NOT_ENOUGH("46018","优惠券不满足可用金额门槛",""),

    SHOPPING_CART_USER_HAVE_NO_COUPON("46019", "使用的商品券已失效,请重新下单",""),
    /**
     * 加价购商品
     */
    PREMIUM_EXCHANGE_ACTIVITY_NOT_EXIST("47001", "换购商品已失效啦，请重新下单",""),
    PREMIUM_EXCHANGE_SKU_DEFICIENCY("47002", "您选择的换购商品库存不足，请重新下单",""),

    /**
     * 微信卡券
     */
    WEICHAT_SHOP_NOTSUPPORT("48001","当前门店不可用",""),
    WEICHAT_NOT_PRODUCTCARD("48002","不是商品券不用加入购物车",""),
    WEICHAT_PRODUCT_NOEXIST("48003","商品不存在",""),

    /**
     * 配送单
     */
    DELIVERY_QUERY_ERROR("50024","查询配送单失败",""),
    DELIVERY_CANCEL_ORDER_ERROR("53012", "取消配送单失败",""),
    DELIVERY_REMINDER_ORDER_ERROR("53013", "订单状态不是配送中，不能催单",""),
    DELIVERY_QUERY_RIDER_STATUS_ERROR("53014", "订单状态不是配送中，不能查询骑手位置",""),
    DELIVERY_REMINDER_ERROR("53015","催单失败",""),
    DELIVERY_QUERY_RIDER_ERROR("53016","查询骑手位置失败",""),
    DELIVERY_NOT_EXIST("53017","当前订单没有配送单",""),

    /**
     * 配送信息
     */
    DELIVERY_INFO_NOT_DELIVERY("60001", "当前地址不可配送",""),
    DELIVERY_INFO_ERROR("60002","配送地址不正确",""),
    DELIVERY_CREATE_ERROR("60003","运单不足，配送失败",""),


    /**
     * coco券验证失败
     */
    COCO_COUPON_VALIDATOR_FAIL("70000", "优惠券验证错误",""),


    /**
     * 拼团订单状态码 80001 - 80101
     */
    SPELL_GROUP_THE_CLUB_IS_FULL("80001", "拼团已满员",""),
    SPELL_GROUP_CREAT_ORDER_ERROR("80002", "创建拼团订单失败",""),
    SPELL_GROUP_ACTIVITE_AMOUNT_ERROR("80003", "库存不足或者活动关闭",""),
    SPELL_GROUP_QUERY_ORDER_RECEIVE_ADDRESS_ERROR("80004", "获取地址信息异常",""),
    SPELL_GROUP_QUERY_PRODUCT_INFOS_ERROR("80005", "获取商品信息异常",""),
    SPELL_GROUP_QUERY_CALCULATION_DISCOUNT_ERROR("80006", "获取算价信息异常",""),
    SPELL_GROUP_QUERY_GROUP_WORK_ERROR("80007", "查询拼团信息异常",""),
    SPELL_GROUP_QUERY_GROUP_STATUS_IS_NOT_NORMAL("80008", "团状态非正常",""),
    SPELL_GROUP_QUERY_DELIVERYTEMPLATE_ERROR("80009", "查询配送费异常",""),
    SPELL_GROUP_ISJOIN_ERROR("80010", "用户已经参与此团，不能再次参与",""),
    SPELL_GROUP_QUERY_BIND_STORE_ERROR("80011", "查询虚拟门店失败",""),
    GROUP_DOES_NOT_EXIST("720", "团不存在",""),
    PARTICIPATE_IN_THE_GROUP_OVERRUN("80022", "参与拼团次数达到上限",""),

    SPELL_GROUP_REFUND_ERROR("80015", "取消拼团失败",""),

    /**
     * 用于标识虚拟商品是否限制购买数量订单识别状态码 80102 - 80110
     */
    USER_BUY_PRODUCT_MORE_THAN_THE_NUMBER("80102", "虚拟商品限制购买数量超过最大购买数",""),
    USER_BUY_PRODUCT_ALREADY("80103", "只能购买一次哦，您已经购买过了",""),


    ;





    private String code;
    private String message;
    private String enMessage;

    /**
     * @param code    状态码
     * @param message 提示信息
     */
    ResponseResult(String code, String message,String enMessage) {
        this.code = code;
        this.message = message;
        this.enMessage = enMessage;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getEnMessage() {
        return enMessage;
    }

    public void setEnMessage(String enMessage) {
        this.enMessage = enMessage;
    }

    public static ResponseResult getResponseResult(String code) {
        ResponseResult[] values = ResponseResult.values();
        for (ResponseResult value : values) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
}
