package cn.freemud.entities.vo;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.Min;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OrderProductVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping1.wu
 * @date: 2020/4/23 16:14
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class OrderProductVo {

    @NotEmpty(message = "spuId不能为空")
    private String spuId;

    private String skuId;
    /**
     * 商品额外的属性
     */
    private List<OrderProductExtraVo> extra;

    private String appType;

    /**
     * 数量
     */
    @Min(value = 1,message = "数量不能小于1")
    private Integer qty;

    /**
     * 套餐固定商品
     */
    private List<OrderProductComboxVo> productComboList;
    /**
     * 套餐可选商品
     */
    private List<OrderProductComboxVo> productGroupList;

}
