package cn.freemud.service.impl.calculate.promotion;

import cn.freemud.entities.dto.ActivityCalculationDiscountResponseDto;
import cn.freemud.entities.dto.CheckSpqInfoResponseDto;
import cn.freemud.entities.dto.activity.ActivityDiscountsDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.CouponFlag;
import cn.freemud.service.CouponService;
import com.freemud.sdk.api.assortment.shoppingcart.constant.CommonsConstant;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: cn.freemud.service.impl.calculate.coupon PromotionService
 * @Description: TDO 描述....
 * @author: family
 * @date: 2020/9/8
 * @Copyright: www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class CouponSharingService {

    @Autowired
    private CouponService couponService;

    public void updateShoppingCartGoodsDiscount(CalculationSharingDiscountResponseDto.CalculationDiscountResult calculationDiscountResult
            , List<CartGoods> cartGoodsList
            , ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo
            , CouponPromotionVO couponPromotionVO) {
        // 用户选择了查询优惠券信息
        if (couponPromotionVO != null && ObjectUtils.equals(CouponFlag.YES.getCode(), couponPromotionVO.getFlg())) {
            List<CartGoods> tmpCartGoods = cartGoodsList.parallelStream().filter(k -> k.getCartGoodsUid()
                    .startsWith(CommonsConstant.COUPON_PREFIX)).collect(Collectors.toList());
            // 是否存在商品券
            boolean hasGoodssCoupon = CollectionUtils.isNotEmpty(tmpCartGoods);
            // 构建可用不可用优惠券
            ActivityClassifyCouponBean activityClassifyCouponBean = couponService.availableCoupon(cartGoodsList
                    , couponPromotionVO.getPartnerId()
                    , couponPromotionVO.getUserId()
                    , couponPromotionVO.getStoreId()
                    , couponPromotionVO.getCouponCode()
                    , hasGoodssCoupon
                    , couponPromotionVO.getOrderType()
                    , 1);
            if (Objects.equals(activityClassifyCouponBean, null)) {
                // 构建一个空得订单券信息
                activityClassifyCouponBean = createEmptyActivityCouponBean();
            }
            shoppingCartGoodsResponseVo.setAvailableCoupon(activityClassifyCouponBean);
        } else {
            // 构建一个空得订单券信息
            ActivityClassifyCouponBean activityClassifyCouponBean = createEmptyActivityCouponBean();
            shoppingCartGoodsResponseVo.setAvailableCoupon(activityClassifyCouponBean);
        }

        // 当couponCode不为空时，需计算优惠价格 3代金 31折扣  32商品  33换购券
        long couponDiscount = 0;
        if (couponPromotionVO != null && StringUtils.isNotEmpty(couponPromotionVO.getCouponCode())
                && calculationDiscountResult != null && CollectionUtils.isNotEmpty(calculationDiscountResult.getDiscounts())) {
            //List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.CouponResults> couponResultsList = calculationDiscountResult.getCouponDiscounts();
            List<Integer> asList = Arrays.asList(3, 31);
            List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.Discount> couponResultsList = calculationDiscountResult.getDiscounts();
            Optional<CalculationSharingDiscountResponseDto.CalculationDiscountResult.Discount> first = couponResultsList.stream().filter(d -> asList.contains(d.getType())).findFirst();
            couponDiscount = first.get().getDiscount().longValue();
        }
        shoppingCartGoodsResponseVo.setCouponDiscount(couponDiscount);
        //循环购物车商品券
        for (CartGoods cartGoods : cartGoodsList) {
            if (cartGoods.getCartGoodsUid().startsWith(CommonsConstant.COUPON_PREFIX)) {
                String spqId = cartGoods.getCartGoodsUid().substring(CommonsConstant.COUPON_PREFIX.length());
                // 计算优惠信息时，已将券校验过，放在map中
                Map<String, CheckSpqInfoResponseDto> validCouponMap = calculationDiscountResult == null ? new HashMap<>() : calculationDiscountResult.getValidCouponMap();
                if (MapUtils.isNotEmpty(validCouponMap)) {
                    CheckSpqInfoResponseDto checkSpqInfoResponseDto = validCouponMap.get(spqId);
                    if (checkSpqInfoResponseDto != null) {
                        cartGoods.setOriginalPrice(checkSpqInfoResponseDto.getPrice());
                        cartGoods.setSpuId(checkSpqInfoResponseDto.getSpuId());
                        cartGoods.setSkuId(StringUtils.isEmpty(checkSpqInfoResponseDto.getSkuId()) ? checkSpqInfoResponseDto.getSpuId() : checkSpqInfoResponseDto.getSkuId());
                        cartGoods.setQty(1);
                        cartGoods.setCouponCode(checkSpqInfoResponseDto.getCouponCode());
                        cartGoods.setSpuName(checkSpqInfoResponseDto.getSpuName());
                    }
                }
            }
        }
    }


    public void updateShoppingCartGoodsApportion(ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo, ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult, ShoppingCartGoodsDto shoppingCartGoodsDto, CreateOrderVo.PremiumExchangeActivity premiumExchangeActivity, ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {
        List<ActivityCalculationDiscountResponseDto.CalculationDiscountResult.CouponResults> couponDiscounts = calculationDiscountResult == null ? new ArrayList<>() : calculationDiscountResult.getCouponDiscounts();
        List<ActivityDiscountsDto> activityDiscountsDtos = shoppingCartGoodsDto.getActivityDiscountsDtos() == null ? new ArrayList<>() : shoppingCartGoodsDto.getActivityDiscountsDtos();

        for (ShoppingCartGoodsDto.CartGoodsDetailDto cartGoods : shoppingCartGoodsDto.getProducts()) {
            if (StringUtils.isNotEmpty(cartGoods.getCouponCode())) {
                for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.CouponResults couponDiscount : couponDiscounts) {
                    ActivityDiscountsDto activityDiscountsDto = getActivityDiscountDto(calculationDiscountResult.getApportionGoods(), couponDiscount);
                    if (activityDiscountsDto != null) {
                        ActivityDiscountsDto activityDiscountsDto1 = new ActivityDiscountsDto();
                        BeanUtils.copyProperties(activityDiscountsDto, activityDiscountsDto1);
                        activityDiscountsDto1.setDiscountAmount(-activityDiscountsDto.getDiscountAmount());

                        cartGoods.setTotalDiscountAmount(-activityDiscountsDto.getDiscountAmount());
                        cartGoods.setSalePrice(0L);
                        cartGoods.setActivityDiscountsDtos(Arrays.asList(activityDiscountsDto1));
                    }
                }
            }
        }

        for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.CouponResults couponDiscount : couponDiscounts) {
            ActivityDiscountsDto activityDiscountsDto = getActivityDiscountDto(calculationDiscountResult.getApportionGoods(), couponDiscount);
            if (activityDiscountsDto != null) {
                activityDiscountsDtos.add(activityDiscountsDto);
            }
        }
        shoppingCartGoodsDto.setActivityDiscountsDtos(activityDiscountsDtos);
    }

    private ActivityDiscountsDto getActivityDiscountDto(List<ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods> apportionGoods, ActivityCalculationDiscountResponseDto.CalculationDiscountResult.CouponResults couponDiscount) {
        String couponCode = couponDiscount.getCouponCode();
        for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods apportionGood : apportionGoods) {
            List<ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods.ApportionDetails> list = apportionGood.getApportionDetails().stream().filter(detail -> ObjectUtils.equals(couponCode, detail.getActivityCode())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(list)) {
                ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods.ApportionDetails apportionDetails = list.get(0);
                ActivityDiscountsDto activityDiscountsDto = new ActivityDiscountsDto();
                activityDiscountsDto.setActivityCode(apportionDetails.getActivityCode());
                activityDiscountsDto.setActivityName(apportionDetails.getActivityName());
                activityDiscountsDto.setActivityType(apportionDetails.getActivityType());
                activityDiscountsDto.setDiscountAmount(0 - couponDiscount.getDiscountAmount());
                return activityDiscountsDto;
            }
        }
        return null;
    }


    public ActivityClassifyCouponBean createEmptyActivityCouponBean() {
        ActivityClassifyCouponBean activityClassifyCouponBean = new ActivityClassifyCouponBean();
        activityClassifyCouponBean.setCouponNum(0);
        activityClassifyCouponBean.setDisableCouponNum(0);
        activityClassifyCouponBean.setUsableCouponNum(0);
        activityClassifyCouponBean.setDisableCoupons(Lists.newArrayList());
        activityClassifyCouponBean.setUsableCoupons(Lists.newArrayList());
        return activityClassifyCouponBean;
    }
}
