package cn.freemud.entities.dto.product;

import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By sunary.site
 *
 * @version v1.0
 * @Title: IntelliJ IDEA
 * @Package cn.freemud.entities.dto.product
 * @Description: 请简单描述下这个类是做什么用的
 * @author: yu.sun
 * @date: 2020-11-25 11:51:44
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 */
@Data
public class ProductTypeBeanDTO {
    private String businessNo;
    private String barcode;
    private String brandId;
    private String brandName;
    private String category;
    private String categoryName;
    private String companyId;
    private String customerCode;
    private String productCode;
    private Long finalPrice;
    private Integer isSkuProduct;
    private String name;
    private Long originalPrice;
    private Long packPrice;
    private String picture;
    private String pid;
    private String specification;
    private Integer status;
    private Integer stock;
    private Integer stockLimit;
    private int type;
    private String unit;
    private Integer riseSell;
    private String rawMaterial;
    private Double tax;
    private String taxId;
    private Integer openMemberDiscount;
    private Integer memberDiscount;
    private List<ProductBindingCouponType> productBindingCouponTypes;
    private List<ProductAttributeGroupListBean> productAttributeGroupList;
    private List<ProductPictureListBean> productPictureList;
    private List<SkuProductBean> skuList;
    private List<ProductComboType> productComboList;
    private List<ProductGroupType> productGroupList;
    private List<SkuProductBean.SkuSpecValue> skuSpecValues;
    private List<PackageProductTypeDto> packageProductTypes;
    private List<ProductGroupType> additionalGroupList;
    private List<ProductComboDetailTypeDto> productComboInfos;
    private Integer isDishware;
    private Integer weightType;
    private Double weight;

    public Integer getMemberDiscountResult() {
        return this.openMemberDiscount != null && this.openMemberDiscount == 1 ? this.memberDiscount : 100;
    }

    public ProductTypeBeanDTO() {
    }

    @Data
    public static class ProductComboDetailTypeDto {
        private String productId;
        private Integer quantity;
        private Integer sequence;

        public ProductComboDetailTypeDto() {
        }
    }

    @Data
    public static class ProductAttributeGroupListBean {
        private String attributeName;
        private Integer attributeType;
        private List<AttributeValueBean> attributeValues;

        public ProductAttributeGroupListBean() {
        }
    }

    @Data
    public static class AttributeValueBean {
        private String attributeId;
        private String attributeValue;
        private Long id;
        private Long price;
        private Integer sequence;
        private Integer status;

        public AttributeValueBean() {
        }
    }

    @Data
    public static class PackageProductTypeDto {
        private Long groupId;
        private Integer sequence;

        public PackageProductTypeDto() {
        }
    }

    @Data
    public static class ProductGroupType {
        private String pgid;
        private String linkId;
        private String groupCode;
        private String options;
        private String name;
        private Integer must;
        private Integer allowRepeat;
        private Integer minNumber;
        private Integer maxNumber;
        private String remark;
        private Integer total;
        private List<ProductGroupType.GroupDetailType> groupDetail;

        public ProductGroupType() {
        }

        @Data
        public static class GroupDetailType {
            private String productId;
            private String productName;
            private String customerCode;
            private Integer productPrice;
            protected Integer productFinalPrice;
            protected Integer markUpPrice;
            private String picture;
            private Integer stockLimit;
            protected String unit;
            protected String productCode;
            private Integer weightType;
            private Double weight;
            private Double tax;
            private String taxId;
        }
    }

    @Data
    public static class ProductComboType {
        private String productId;
        private String productName;
        private String customerCode;
        private Integer originalPrice;
        protected Integer finalPrice;
        protected Integer packPrice;
        private String picture;
        protected String unit;
        protected String productCode;
        private Integer quantity;
        private Integer weightType;
        private Double weight;
        private Double tax;
        private String taxId;
    }

    @Data
    public static class ProductPictureListBean {
        private String pictureId;
        private String productId;
        private String sequence;
        private String type;
        private String url;

        @Data
        public static class AttributeValueBean {
            private String attributeId;
            private String attributeValue;
            private Long id;
            private Long price;
            private Integer sequence;
            private Integer status;

            public AttributeValueBean() {
            }
        }
    }

    @Data
    public static class ProductLabelNameListBean {
        private String id;
        private String name;
        private String partnerId;
        List<?> productList;
        private String storeId;
        private String type;

        public ProductLabelNameListBean() {
        }
    }

    @Data
    public static class SpecificationGroupBean {
        private String partnerId;
        private Integer sequence;
        private String specId;
        private String specName;
        private List<SpecificationGroupBean.SpecValueVo> specValueVos;

        public SpecificationGroupBean() {
        }

        @Data
        public static class SpecValueVo {
            private Integer sequence;
            private String specId;
            private String specValue;
            private String specValueId;

            public SpecValueVo() {
            }
        }
    }

    @Data
    public static class SkuProductBean {
        private String customerCode;
        private String productCode;
        private Long finalPrice;
        private Long originalPrice;
        private String productName;
        private Integer productType;
        private Integer sequence;
        private String skuCode;
        private String skuId;
        private Integer status;
        private Integer stockLimit;
        private Integer stockQty;
        private Long packPrice;
        private Integer riseSell;
        private String rawMaterial;
        private Double tax;
        private String taxId;
        private List<SkuProductBean.SkuSpecValue> skuSpecValues;
        private List<ProductGroupType> additionalGroupList;
        private Double weight;
        protected String unit;
        private Integer openMemberDiscount;
        private Integer memberDiscount;

        public Integer getMemberDiscountResult() {
            return this.openMemberDiscount != null && this.openMemberDiscount == 1 ? this.memberDiscount : 100;
        }

        public SkuProductBean() {
        }

        @Data
        public static class SkuSpecValue {
            private String productId;
            private Integer sequence;
            private String specId;
            private String specName;
            private String specValue;
            private String specValueId;

            public SkuSpecValue() {
            }
        }

        @Data
        public static class PackageProductTypeDto {
            private Long groupId;
            private Integer sequence;

            public PackageProductTypeDto() {
            }
        }
    }
}
