package cn.freemud.service.thirdparty;

import cn.freemud.entities.dto.store.StoreCBaseResponseDto;
import cn.freemud.entities.dto.store.StoreInfoRequestDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/6/4 下午2:04
 * @description : 门店基础服务
 */
@FeignClient(name = "store-menu-application-service")
@RequestMapping(value = "/store", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public interface StoreBaseApiClient {

    @PostMapping(value = "/delivery/queryExpectArriveTime")
    StoreCBaseResponseDto queryDeliverDetail(@RequestBody StoreInfoRequestDto request);
}
