/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ActivityService
 * @Package cn.freemud.service
 * @Description:
 * @author: song.cai
 * @date: 2019/1/2 14:10
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service;

import cn.freemud.entities.dto.ActivityQueryRequestDto;
import cn.freemud.entities.dto.activity.ActivityQueryDto;
import cn.freemud.entities.dto.activity.ActivityQueryResponseDto;
import cn.freemud.enums.ActivityTypeEnum;

import java.util.List;

public interface ActivityService {

    /**
     * 统一活动查询
     *
     * @param activityQueryDto
     * @param activityTypeEnum
     * @param goodsBeanDtoList
     * @return
     */
    ActivityQueryResponseDto queryActivitys(ActivityQueryDto activityQueryDto, ActivityTypeEnum activityTypeEnum,
                                            List<ActivityQueryRequestDto.QueryGoodsBeanDto> goodsBeanDtoList);


    /**
     * 根据不同的activityTypes 查询活动
     *
     * @param activityQueryDto
     * @param activityTypeEnums
     * @param goodsBeanDtoList
     * @return
     */
    ActivityQueryResponseDto queryActivityByType(ActivityQueryDto activityQueryDto, List<ActivityTypeEnum> activityTypeEnums, List<ActivityQueryRequestDto.QueryGoodsBeanDto> goodsBeanDtoList);


}
