package cn.freemud.entities.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Objects;

/**
 * 查询订单状态监控信息参数
 *
 * @version: 1.0
 * @Description: TODO
 * @author: WangShiChang
 * @date: 2021/5/13 下午4:36
 * @Copyright: www.freemud.cn Inc.
 */
@ApiModel("查询订单状态监控信息 参数")
@Data
public class QueryStateMonitorInfoResp implements Serializable {

    private static final long serialVersionUID = -3946903275418853516L;

    /**
     * 订单编号
     */
    @ApiModelProperty(value = "订单编号", required = true)
    @NotBlank(message = "订单编号为空")
    private String orderCode;

    /**
     * 订单下单渠道
     */
    @ApiModelProperty(value = "订单下单渠道")
    private Byte orderClient;

    /**
     * 商户ID
     */
    @ApiModelProperty(value = "商户ID")
    @NotBlank(message = "商户ID为空")
    private String partnerId;

}
