package com.freemud.sdk.api.assortment.order.request.order;

import com.freemud.sdk.api.assortment.order.config.BaseConfig;
import lombok.Data;

import java.util.List;

@Data
public class QueryOrdersRequest extends BaseConfig {

    /**
     * 用户会员ID
     */
    private String userId;
    /**
     * 商户ID
     */
    private String companyId;
    /**
     * 每页显示几条数据
     */
    private Integer pageSize;
    /**
     * 第几页
     */
    private Integer pageNumber;
    /**
     * 订单创建开始日期
     */
    private String startDate;
    /**
     * 订单结束日期
     */
    private String endDate;
    /**
     * 支付状态
     */
    private Integer[] payStatus;
    /**
     * 订单状态
     */
    private Integer[] status;
    /**
     * 退款状态
     */
    private Integer[] refundStatus;
    /**
     * 订单类型    enumsRefundStatus
     */
    private Integer[] type;
    /**
     * 查询是否生成取餐码订单1:是，0 否 ,
     */
    private Integer existTakeCode;
    /**
     * 资源渠道
     */
    private String[] source;

    private List<Integer> bizTypes;

}
