package cn.freemud.management.service.handle;

import cn.freemud.management.adapter.McCafeCouponAdapter;
import cn.freemud.management.entities.dto.request.coupon.MCCafeCouponLockRequest;
import cn.freemud.management.entities.dto.request.coupon.MCCafeCouponRequest;
import cn.freemud.management.thirdparty.CouponOfflineMCCafeClient;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponBaseResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponRedeemResponse;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@Slf4j
public class CouponHandle {

    public final static Integer RESPONSE_SUCCESS = 100;
    @Autowired
    private McCafeCouponAdapter mcCafeCouponAdapter;
    @Autowired
    private CouponOfflineMCCafeClient couponOfflineMCCafeClient;

    /**
     * 异步核销券码
     * @param orderBean
     */
    @Async("couponExecutor")
    public void asyncVerificationCoupon(QueryOrdersResponse.DataBean.OrderBean orderBean){
        List<MCCafeCouponRequest> list = mcCafeCouponAdapter.convertOrderBean2CouponLockRequest(orderBean);
        if (CollectionUtils.isNotEmpty(list)) {
            for (MCCafeCouponRequest mcCafeCouponRequest: list) {
                //重试3次
                for (int i = 2; i >= 0; i--) {
                    log.info("核销券码入参：{}",JSONObject.toJSONString(mcCafeCouponRequest));
                    CouponRedeemResponse redeem = couponOfflineMCCafeClient.redeem(mcCafeCouponRequest);
                    log.info("核销券码出参：{}",JSONObject.toJSONString(redeem));
                    if (RESPONSE_SUCCESS.equals(redeem.getStatusCode())) {
                        break;
                    }
                    if (i == 0 && !RESPONSE_SUCCESS.equals(redeem.getStatusCode())) {
                        log.error("核销券码异常，入参{}，出参：{}", JSONObject.toJSONString(mcCafeCouponRequest), JSONObject.toJSON(redeem));
                    }
                }
            }
        }
    }

    /**
     * 解锁券码
     * @param orderBean
     */
    public void unlock(QueryOrdersResponse.DataBean.OrderBean orderBean){
        List<MCCafeCouponLockRequest> list = mcCafeCouponAdapter.convertOrderBean2UnlockCoupon(orderBean);
        if (CollectionUtils.isNotEmpty(list)) {
            for (MCCafeCouponLockRequest mcCafeCouponLockRequest: list) {
                //重试3次
                for (int i = 2; i >= 0; i--) {
                    CouponBaseResponse response = couponOfflineMCCafeClient.unlock(mcCafeCouponLockRequest);
                    if (RESPONSE_SUCCESS.equals(response.getStatusCode())) {
                        break;
                    }
                    if (i == 0 && !RESPONSE_SUCCESS.equals(response.getStatusCode())) {
                        log.error("解锁券码异常，入参{}，出参：{}", JSONObject.toJSONString(mcCafeCouponLockRequest), JSONObject.toJSON(response));
                    }
                }
            }
        }
    }

}
