package com.freemud.application.sdk.api.ordercenter.enums;

import lombok.Data;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OrderType
 * @Package com.freemud.application.sdk.api.ordercenter.enums
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/9 16:56
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public enum OrderType {

    GENERAL_DINE_IN(1, "店内自取实时-1常规堂食"),
    RESERVED_DINE_IN(2, "店内自取预约-2预约堂食"),
    GENERAL_EXPRESS(3, "店外快递实时-3常规外送"),
    RESERVED_EXPRESS(4, "店外快递预约-4预约外送"),
    GENERAL_SELF_PICKUP(5, "店外自取实时-5常规自取"),
    RESERVED_SELF_PICKUP(6, "店外自取预约-6预约自取"),
    ;

    private Integer index;
    private String name;

    public Integer getIndex() {
        return index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    OrderType() {
    }

    OrderType(Integer index, String name) {
        this.index = index;
        this.name = name;
    }

    public static OrderType getOrderType(Integer type){
        for (OrderType orderType : values()){
            if (type.equals(orderType.index)){
                return orderType;
            }
        }
        return null;
    }
}
