/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderChannelType
 * @Package cn.freemud.enums
 * @Description:
 * @author: liming.guo
 * @date: 2018/7/3 15:06
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.enums;

public enum MCCafeChannelEnum {

    MOCOFFEE_WX(1, "mocoffee_wx", "麦咖啡微信小程序"),
    MOCOFFEE_ZFB(2, "mocoffee_zfb", "麦咖啡支付宝小程序"),
    ;

    private int code;

    private String name;

    private String desc;

    MCCafeChannelEnum(int code, String name, String desc) {
        this.code = code;
        this.name = name;
        this.desc = desc;
    }

    public static MCCafeChannelEnum getByCode(int code) {
        for (MCCafeChannelEnum type : values()) {
            if (type.getCode() == code) {
                return type;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
