package cn.freemud.enums;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ShoppingCartPromotionEnum
 * @Package cn.freemud.enums
 * @Description:
 * @author: jiaxin.liu
 * @date: 2019/4/18 10:31
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public enum ShoppingCartPromotionEnum {
    FULL_REDUCTION(1, "fullPromotionService"),
    TIME_SALE(2, "timeSalePromotionService"),
    COUPON_DISCOUNT(3, "couponPromotionService"),
    BUY_ONE_SEND(4, "buySendPromotionService"),
    ADDITIONAL_BUY(5, "additionalPromotionService"),
    DEFAULT_PROMOTION(0, "defaultPromotionService"),
    CUSTOMER_SCORE(6, "customerScoreService"),
    SET_MEAL(7, "setMealService"),
    XY_DISCOUNT(8, "xyDiscountService"),
    TwoN_DISCOUNT(9, "twoNDiscountService"),
    BUY_GIFTS(10, "buyAndGiftsPromotionService"),
    MEMBER_DISCOUNT(11, "memberDiscountService"),
    Material(12, "MaterialPromotionService");

    private Integer type;
    private String msgType;

    ShoppingCartPromotionEnum(Integer type, String msgType) {
        this.type = type;
        this.msgType = msgType;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getMsgType() {
        return msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }
}
