package cn.freemud.entities.vo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class CreateDeliveryVo {

    /**
     * 商品信息
     * productInfos不能为空
     */
    private List<ProductInfo> productInfos;

    /**
     * 取餐号
     * serialNumber不能为空
     */
    private String serialNumber;

    /**
     * 订单编号
     * orderId不能为空
     */
    private String orderId;

    /**
     * 订单备注
     */
    private String orderRemark;

    /**
     * 订单来源 美团 ，饿了么，百度，口碑 等（中文）
     */
    private String orderSource;

    /**
     * 订单总金额(分)
     * orderTotalAmount不能为空
     * orderTotalAmount不能小于1
     */
    private Integer orderTotalAmount;

    /**
     * 订单实付金额(分)
     * orderActualAmount不能为空
     * orderActualAmount不能小于1
     */
    private Integer orderActualAmount;

    /**
     * 订单重量（kg）
     */
    private BigDecimal depatchWeight;

    /**
     * 发票抬头
     */
    private String invoiceTitle;

    /**
     * 商户id
     */
    private String partnerId;

    /**
     * 商户信息备注
     */
    private String partnerRemark;

    /**
     * 订单渠道
     */
    private String orderChannel;

    /**
     * 配送渠道
     */
    private String deliveryChannel;

    /**
     * 是否预约单 ０否　１是
     * isPre不能为空
     *
     */
    private Integer isPre;

    /**
     * 门店id(非码)
     * storeId不能为空
     */
    private String storeId;

    /**
     * 第三方门店id
     * storeCode不能为空
     */
    private String storeCode;

    /**
     * 门店名称
     * storeName不能为空
     */
    private String storeName;

    /**
     * 门店地址
     * storeAddress不能为空
     */
    private String storeAddress;

    // "门店所在区"
    private String storeArea;

    // "门店所在市"
    private String storeCity;

    // "门店所在省"
    private String storeProvince;

    /**
     * 门店经度
     * storeLng不能为空
     */
    private BigDecimal storeLng;

    /**
     * 门店纬度
     * storeLat不能为空
     */
    private BigDecimal storeLat;

    /**
     * 门店电话
     * storePhone不能为空
     */
    private String storePhone;

    /**
     * 门店联系人
     */
    private String storeContact;

    /**
     * 收货人姓名
     * receiverName不能为空
     */
    private String receiverName;

    /**
     * 收货人联系方式
     * receiverPrimaryPhone不能为空
     */
    private String receiverPrimaryPhone;

    /**
     * 收货人备用联系方式
     */
    private String receiverSecondPhone;

    /**
     * 收货人地址
     * receiverAddress不能为空
     */
    private String receiverAddress;

    /**
     * 收货人经度
     * receiverLng不能为空
     */
    private BigDecimal receiverLng;

    /**
     * 收货人纬度
     * receiverLat不能为空
     */
    private BigDecimal receiverLat;

    /**
     * 所在城市
     * cityName不能为空
     */
    private String cityName;

   //"所在省份"
    private String provinceName;

    //"所在区"
    private String areaName;

    /**
     * 配送服务代码（飞速达:4002；快速达:4011；及时达:4012；集中送:4013）
     */
    private Integer deliveryServiceCode;

    /**
     * 商品类型 1送餐; 2送药; 3百货;4脏衣收; 5干净衣派;6生鲜; 7保单;8饮品；9现场勘查；99其他
     */
    private Integer productType;

    private String callbackUrl;

    /**
     * 用户下单时间
     * orderTime不能为空
     */
    private Date orderTime;


    //用户期望送达时间"
    private Date expectTime;

    // "微信token 渠道为微信物流时必传"
    private String accessToken;

    //"小程序openid 渠道为微信物流时必传"
    private String openId;

    // "商家小程序的路径，建议为订单页面 渠道为微信物流时必传")
    private String wxaPath;

    // "小程序appId 渠道为微信物流时必传")
    private String wxAppId;

    //"微信物流公司id")
    private String wxCompanyId;

    //"微信物流公司快递编码")
    private String wxBizId;

    //"微信物流公司服务类型ID")
    private Integer serviceType;

    // "微信物流公司服务类型名称")
    private String serviceName;

    //"非码运单号")
    private String deliveryId;

    //"是否大订单 ：  0-否 , 1-是")
    private Integer isLargeOrder;

    // "是否实时送达：   0-否 , 1-是")
    private Integer isImmediateDelivery;

    // "预计送达时间-UTC 时间")
    private String expectDeliveryTimeByUTC;

    // "餐品总额(单位:分)")
    private Integer productTotal;

    // "是否支付：  0-否 , 1-是 ")
    private Integer isPayed;

    // "付款类型")
    private String tenderType;

    //"启用新版税率规则计算开票：0-关闭，1-开启")
    private Integer taxFlag;

    //"配送费(单位:分)"
    private Integer deliveryTotal;

    // "订单显示ＩＤ(餐道专用)")
    private String displayOrderId;


}
