/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ActivityTip
 * @Package cn.freemud.entities.vo
 * @Description: 购物车活动Tip
 * @author: song.cai
 * @date: 2018/12/28 19:15
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.entities.vo;

import lombok.Data;

import java.util.List;

@Data
public class ActivityTip {
    /**
     * 活动号
     */
    private String activityCode;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 活动类型：
     * 1-整单满减
     * 11-每满减
     * 12-阶梯满减
     * 13-新用户立减
     * 2-单品特价
     * 21-单品折扣
     * 3-优惠券
     * 5-整单满金额折
     * 51-每满金额折
     * 52-阶梯满金额折
     * 53-第M件/杯N折
     * 6-买M赠N
     * 7-满额赠券
     * 8-满N件换购
     * 81-满额换购
     * 82-阶梯满数量打折
     * 100-阶梯满数量打折
     * 101-整单满数量打折
     * 102-阶梯单品满N件打折
     * 103-阶梯单品满M件减N元
     * 200-X元Y件
     */
    private Integer activityType;
    private List<ActivityList> activityList;
    /**
     *
     */
    private Integer maxNum;
    private Integer minNum;
    /**
     * 1.5.5版本添加
     * 每单可以参与买一赠一商品总数
     */
    private Integer activityQty;
    /**
     * 1.5.5版本添加
     * 购物车中参与买一赠一商品个数
     */
    private Integer activityCartQty;
    /**
     * 1.5.5版本添加
     * 购物车中属于买一赠一商品的数据
     */
    private List<String> activitySpuIds;
}
