package cn.freemud.entities.db;

import cn.freemud.comm.entity.BaseEntity;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OpenPlatformIappWxappStore
 * @Package cn.freemud.entities.db
 * @Description: 简单描述下这个类是做什么用的
 * @author: zhenghuan.yang
 * @date: 2018/9/6 13:24
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
@Table(name = "open_platform_iapp_wxapp_store")
public class OpenPlatformIappWxappStore extends BaseEntity implements Serializable {
    /**
     * 主键ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 自定义小程序appid
     */
    @Column(name = "appid")
    private String appId;

    /**
     * 微信小程序appid
     */
    @Column(name = "wx_appid")
    private String wxAppId;

    /**
     * 门店id
     */
    @Column(name = "store_id")
    private String storeId;

    /**
     * 门店code
     */
    @Column(name = "store_code")
    private String storeCode;

    /**
     * 1 有效  0 无效
     */
    @Column(name = "status")
    private Integer status;

    /**
     * 创建时间
     */
    @Column(name = "gmt_created")
    private String gmtCreated;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private String gmtModified;
}
