package cn.freemud.fuyou.feign.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class BasicReq {

    @ApiModelProperty(value = "接口版本，必须为2", position = 1)
    private String ver;

    @ApiModelProperty(value = "商户编号（由非码提供）", position = 2, required = true)
    private String partnerId;

    @ApiModelProperty(value = "商家门店号（在线支付需要提前定义）", position = 3, required = true)
    private String storeId;

    @ApiModelProperty(value = "商家门店名称", position = 3)
    private String storeName;

    @ApiModelProperty(value = "外部交易流水号，由上游系统生成，需保证唯一", position = 4, required = true)
    private String frontTransId;

    @ApiModelProperty(value = "业务日期: yyyy-MM-dd HH:mm:ss 例如：2019-01-01 22:19:00", position = 5)
    private String businessDate;

    @ApiModelProperty(value="卡号,svc用" )
    private String cardCode;


    @ApiModelProperty(value = "支付客户端代码，通过支付平台配置接口生成", position = 8)
    private Long clientCode;

    @ApiModelProperty(value = "支付条码", position = 2)
    private String code;

    @ApiModelProperty(value = "支付渠道code")
    private String payCode;


    private Boolean isVer3 = false;

}
