/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CouponService
 * @Package cn.freemud.service
 * @Description:
 * @author: pengfei.liu
 * @date: 2020/11/23
 * @version V1.0
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service.delivery.impl;

import cn.freemud.entities.ExtraDeliveryDto;
import cn.freemud.entities.dto.console.*;
import cn.freemud.entities.vo.ShoppingCartGoodsResponseVo;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.delivery.DeliveryService;
import cn.freemud.service.thirdparty.ConsoleApiClient;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.storecenter.request.StoreInfoRequest;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import com.freemud.application.sdk.api.storecenter.service.StoreCenterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

@Service("fixDeliveryService")
public class FixDeliveryServiceImpl extends AbstractDeliveryServiceImpl implements DeliveryService {

    @Autowired
    private StoreCenterService storeCenterService;

    @Autowired
    private ConsoleApiClient consoleApiClient;

    @Override
    public Long calculateDeliveryAmount(String receiveId, String partnerId, String storeId, ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo) {

        // 获取门店信息，查询基础配送费用  移除sdk使用, 使用feign
        GetStoreMixRequest query = GetStoreMixRequest.builder()
                .partnerId(partnerId)
                .storeCode(storeId)
                .query(QueryFlag.builder().queryDeliveryInfo(true).build())
                .build();
        ConsoleResponseDTO<BizDTO> responseDto = consoleApiClient.getStoreMix(query);
        DeliveryInfoDTO deliveryInfo = responseDto.getBizVO().getDeliveryInfo();
        // fisherman 处理 额外配送费
        long amount = Objects.isNull(deliveryInfo) || Objects.isNull(deliveryInfo.getFinalDeliveryAmount()) ? 0L : deliveryInfo.getFinalDeliveryAmount();
        List<ExtraDeliveryDto> deliveryAmountList = super.nightDeliveryAmountHandle(amount, deliveryInfo.getExpandFields());
        if (Objects.nonNull(shoppingCartGoodsResponseVo)) {
            shoppingCartGoodsResponseVo.setDeliveryFeeZeroReason(0);
            shoppingCartGoodsResponseVo.setDeliveryAmountList(deliveryAmountList);
        }
        return amount;
    }

    @Override
    public Long calculateDeliveryAmount(String receiveId, String partnerId, String storeId) {
        String trackingNo = LogThreadLocal.getTrackingNo();

        // 获取门店信息，查询基础配送费用
        StoreInfoRequest storeInfoRequest = new StoreInfoRequest(partnerId, storeId,null);
        StoreResponse storeResponse = storeCenterService.getStoreInfo(storeInfoRequest, trackingNo);
        if (storeResponse == null || storeResponse.getBizVO() == null) {
            throw new ServiceException (ResponseResult.STORE_NOT_FOUND);
        }
        return new Double(storeResponse.getBizVO().getDeliveryPrice() * 100).longValue();
    }

}
