package cn.freemud.service.thirdparty;


//import cn.freemud.constant.IgnoreFeignLogAnnotation;

import cn.freemud.annotations.LogIgnoreFeign;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.BatchQueryActivityInfoRequestDto;
import cn.freemud.entities.dto.GetCouponDetailResponseDto;
import cn.freemud.entities.dto.coupon.*;
import cn.freemud.interceptor.FormSupportConfig;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

//@IgnoreFeignLogAnnotation
@FeignClient(name = "OPEN-STORE-ONLINE-COUPON-SERVICE", url = "${saas.coupononlineclient.feign.url}", configuration = FormSupportConfig.class)
public interface CouponOnlineClient {


    /**
     * 获取密钥
     * @param requestDto
     * @return
     */
    @LogIgnoreFeign(messageFieldName= ResponseCodeKeyConstant.MSG,statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE,logMessage="getAppKey")
    @PostMapping("/getAppKey")
    cn.freemud.entities.dto.GetAppKeyResponseDto getAppKey(cn.freemud.entities.dto.GetAppKeyRequestDto requestDto);

    /**
     * 活动信息批量查询
     * @param requestDto
     * @return
     */
    @LogIgnoreFeign(messageFieldName= ResponseCodeKeyConstant.MSG,statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE,logMessage="batchQueryActivityInfo")
    @PostMapping(value = "/batchQueryActivityInfo")
    cn.freemud.entities.dto.BatchQueryActivityInfoResponseDto batchQueryActivityInfo(BatchQueryActivityInfoRequestDto requestDto);
    /**
     * 查询券详情
     */
    @PostMapping(value = "/code_v4", produces = MediaType.APPLICATION_JSON_UTF8_VALUE,
            consumes = {MediaType.APPLICATION_FORM_URLENCODED_VALUE}
    )
    @LogIgnoreFeign(logMessage="getCouponDetails",messageFieldName= ResponseCodeKeyConstant.MSG,statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE)
    GetCouponDetailResponseDto getCouponDetails(@RequestParam Map<String, ?> map);

    /**
     * 查询券详情
     */
    @LogIgnoreFeign(logMessage="invalidCoupons",messageFieldName= ResponseCodeKeyConstant.MSG,statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping(value = "/coupon/state/invalid/coupons")
    InvalidCouponsResponseDto invalidCoupons(@RequestBody InvalidCouponsRequestDto invalidCouponsRequestDto);


    /**
     *  新版 根据券模板查询 券基础信息数据
     * @param request
     * @return
     */
    @LogIgnoreFeign(logMessage="fastBatchQueryTemplateInfo",messageFieldName= ResponseCodeKeyConstant.MSG,
            statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping(value = "/fastBatchQueryTemplateInfo")
    CouponResponseDTO<List<FastTemplateInfoResponseVO>> fastBatchQueryTemplateInfo(@RequestBody FastBatchQueryTemplateInfoRequest request);

    /**
     *  调用券码,作废券
     * @param request
     * @return
     */
    @LogIgnoreFeign(logMessage="checkandcancel",messageFieldName= ResponseCodeKeyConstant.MSG,
            statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping(value = "/coupon/standard/checkandcancel" , produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    CouponResponseDTO<CheckAndCancelResponseDTO> checkandcancel(@RequestBody CheckAndCancelRequest request);

}
