package cn.freemud.enums;

import lombok.Getter;

@Getter
public enum UserLoginChannelEnum {
    OTHER("0", "其他"),
    WEIXIN("1", "微信"),
    ALIPAY("2", "支付宝"),
    APP("3", "APP"),
    /**
     *  抖音小程序客户端
     *  根据业务代码反推添加
     *  我也不知道4是什么, 有了再添加
     */
    TIKTOKPAY("5", "抖音小程序");

    private final String code;
    private final String desc;

    UserLoginChannelEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public static UserLoginChannelEnum get(String code) {
        for (UserLoginChannelEnum e : values()) {
            if (e.getCode().equals(code))  return e;
        }
        return UserLoginChannelEnum.OTHER;
    }
}
