/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartAdapter
 * @Package cn.freemud.adapter
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/26 17:42
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.adapter;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ShoppingCartAdapter {

    public String getExtraName(String skuName, String attributeNames) {
        if (StringUtils.isBlank(skuName)) {
            skuName = "";
        }
        if (StringUtils.isBlank(attributeNames)) {
            attributeNames = "";
        }
        skuName = skuName.replace("|", "/") + "/" + attributeNames;
        String[] names = skuName.split("/");
        StringBuilder extraName = new StringBuilder("");
        if (names.length >= 2) {
            for (int i = 1; i < names.length; i++) {
                if (i == names.length - 1) {
                    extraName.append(names[i]);
                } else {
                    extraName.append(names[i]).append("/");
                }
            }
        }
        return extraName.toString();
    }

    public String getForeignExtras(String skuNameEn, String attributeNamesEn) {
        if (StringUtils.isBlank(skuNameEn)) {
            skuNameEn = "";
        }
        if (StringUtils.isBlank(attributeNamesEn)) {
            attributeNamesEn = "";
        }
        skuNameEn = skuNameEn.replace("|", "/") + "/" + attributeNamesEn;
        String[] names = skuNameEn.split("/");
        StringBuilder extraName = new StringBuilder("");
        if (names.length >= 2) {
            for (int i = 1; i < names.length; i++) {
                if (i == names.length - 1) {
                    extraName.append(names[i]);
                } else {
                    extraName.append(names[i]).append("/");
                }
            }
        }
        return extraName.toString();
    }
}
