package cn.freemud.fuyou.controller.request;

import com.freemud.application.sdk.api.ordercenter.request.create.OrderItemCreateReq;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.util.List;

@Getter
@Setter
public class BaseRequest {

    /**
     * 订单号
     */
    //@NotEmpty(message = "订单号不能为空")
    private String orderCode;

    @NotEmpty(message = "thirdOrderCode 不能为空")
    private String thirdOrderCode;

    /**
     * userId
     */
    @NotEmpty(message = "用户id不能为空")
    private String userId;

    /***
     * posid
     */
    @NotEmpty(message = "posId不能为空")
    private String posId;

    @NotEmpty(message = "商户id不能为空")
    //商户号
    private String partnerId;

    @NotEmpty(message = "门店id不能为空")
    private String storeId;


    /**
     * 支付渠道
     * 1. 微信，2.支付宝，3.现金 4.svc，5.积分,6优惠券
     */
    @NotNull(message = "支付渠道不能为空")
    private Integer payChannel;

    /**
     * 支付金额  单位:分
     */
    @NotNull(message = "支付金额不能为空")
    private Long payAmount;

    /***
     * 支付码，微信，支付宝，svc
     */
    private String code;
    /**
     * 操作人
     */
    private String operator;

    /**
     * 商品信息
     */
    private List<OrderItemCreateReq> orderItemList;


    /***
     * 扩展字段
     * 支付流水号 ，用来查询支付信息,支付接口返回的无需入参
     */
    private String fmId;


    /**
     *  根据 thirdOrderCode 查询的数据
     */
    private OrderInfoReqs orderInfoReqs;


}
