package cn.freemud.service;

import cn.freemud.ShoppingCartApplication;
import cn.freemud.entities.dto.CheckSpqInfoRequestDto;
import cn.freemud.entities.dto.CheckSpqInfoResponseDto;
import cn.freemud.entities.dto.GetCouponDetailResponseDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.StoreItemStatus;
import cn.freemud.service.impl.calculate.CalculationCommonService;
import cn.freemud.service.impl.calculate.CalculationSharingEquallyService;
import cn.freemud.service.impl.calculate.promotion.AdditionSharingService;
import cn.freemud.service.impl.calculate.promotion.FullSharingService;
import cn.freemud.service.impl.calculate.promotion.GiftSharingService;
import cn.freemud.utils.FileUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title:
 * @Package: com.freemud.card.sdk
 * @Description:
 * @author: genyou.cui
 * @date: 2018/12/17 16:34
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes = ShoppingCartApplication.class)
public class CartTest {

    private static final Logger logger = LoggerFactory.getLogger(CartTest.class);
    @Autowired
    private GiftSharingService giftSharingService;
    @Autowired
    private CalculationCommonService calculationCommonService;
    @Autowired
    private FullSharingService fullSharingService;
    @Autowired
    private AdditionSharingService additionSharingService;

    @Autowired
    private CalculationSharingEquallyService calculationSharingEquallyService;


    @Test
    public void cartTest() {
        ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo = new ShoppingCartGoodsResponseVo();
        /**
         * json string
         */
        String cartGoodsListStr = "[{\"spuName\":\"咖喱鸡套餐\",\"originalPrice\":4300,\"goodsId\":\"186791599886416647\",\"productMaterialList\":[],\"customerCode\":\"20200924001\",\"finalPrice\":200,\"createTimeMili\":1603262065331,\"pic\":\"https://picture.sandload.cn/1600916765127.png\",\"productComboList\":[{\"spuName\":\"桔子单品08\",\"originalPrice\":900,\"goodsId\":\"186550397524170796\",\"customerCode\":\"20200921008\",\"finalPrice\":900,\"pic\":\"https://picture.sandload.cn/1600683267756.png\",\"extra\":[],\"skuId\":\"186550397524170796\",\"amount\":900,\"weight\":0.0,\"tax\":0.01,\"weightType\":false,\"unit\":\"斤\",\"originalAmount\":900,\"taxId\":\"\",\"qty\":1,\"name\":\"桔子单品08\"},{\"spuName\":\"桔子单品09\",\"originalPrice\":1000,\"goodsId\":\"186550397560870958\",\"customerCode\":\"20200921009\",\"finalPrice\":1000,\"pic\":\"https://picture.sandload.cn/1600683289350.png\",\"extra\":[],\"skuId\":\"186550397560870958\",\"amount\":1000,\"weight\":0.0,\"tax\":0.01,\"weightType\":false,\"unit\":\"斤\",\"originalAmount\":1000,\"taxId\":\"\",\"qty\":1,\"name\":\"桔子单品09\"}],\"categoryName\":\"套餐\",\"originalMaterialAmount\":0,\"packPrice\":0,\"skuName\":\"咖喱鸡套餐\",\"riseSell\":1,\"classificationName\":\"肉\",\"productGroupList\":[{\"spuName\":\"桔子单品05\",\"originalPrice\":600,\"goodsId\":\"186550397401487398\",\"productGroupId\":186791000549735219,\"customerCode\":\"20200921005\",\"finalPrice\":100,\"pic\":\"https://picture.sandload.cn/1600682885597.png\",\"extra\":[],\"skuId\":\"186550397401487398\",\"amount\":400,\"weight\":0.0,\"tax\":0.01,\"weightType\":false,\"unit\":\"斤\",\"originalAmount\":2400,\"taxId\":\"\",\"qty\":4,\"name\":\"桔子单品05\"}],\"memberDiscount\":100,\"skuId\":\"186791599886416647\",\"amount\":4300,\"cartGoodsUid\":\"5b1acd69-dcce-4037-b8a1-22c02931df4d\",\"stockLimit\":false,\"weight\":0.0,\"tax\":1.01,\"classificationId\":\"meat\",\"goodsType\":3,\"weightType\":false,\"unit\":\"\",\"originalAmount\":4300,\"subName\":\"\",\"taxId\":\"11111\",\"qty\":1,\"name\":\"咖喱鸡套餐\",\"materialAmount\":0,\"spuId\":\"186791599886416647\"}]";
        List<CartGoods> cartGoodsList = JSONObject.parseObject(cartGoodsListStr, new TypeReference<List<CartGoods>>() {
        });

        String discountResultStr = "{\"couponDiscounts\":[],\"originalTotalAmount\":2300,\"totalDiscountAmount\":1900,\"deliveryAmount\":0,\"distributionFee\":0,\"goods\":[{\"gift\":false,\"smallMaterial\":[{\"realAmount\":266,\"discounts\":[{\"activityCode\":\"88607489357455572654\",\"goodsId\":\"186550397401487398\",\"activityName\":\"2元代金券da\",\"actualGoodsNumber\":0,\"discount\":134,\"type\":3,\"activityDesc\":\"2元代金券da\"}],\"originalPrice\":100,\"goodsId\":\"186550397401487398\",\"discountAmount\":134,\"goodsQuantity\":4,\"type\":2}],\"groupCombox\":[{\"discounts\":[{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"186550397524170796\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":799,\"type\":310,\"activityDesc\":\"套餐活动优惠\"},{\"goodsId\":\"186550397524170796\",\"activityName\":\"2元代金券da\",\"actualGoodsNumber\":0,\"discount\":31,\"type\":3}],\"originalPrice\":900,\"goodsId\":\"186550397524170796\",\"discountAmount\":830,\"goodsQuantity\":1},{\"discounts\":[{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"186550397560870958\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":901,\"type\":310,\"activityDesc\":\"套餐活动优惠\"},{\"goodsId\":\"186550397560870958\",\"activityName\":\"2元代金券da\",\"actualGoodsNumber\":0,\"discount\":34,\"type\":3}],\"originalPrice\":1000,\"goodsId\":\"186550397560870958\",\"discountAmount\":935,\"goodsQuantity\":1}],\"cartGoodsUid\":\"5b1acd69-dcce-4037-b8a1-22c02931df4d\",\"originalPrice\":1900,\"goodsId\":\"186791599886416647\",\"actualGoodsNumber\":1,\"discountAmount\":1766,\"meal\":true,\"realAmount\":134,\"nowPrice\":200,\"discounts\":[{\"activityCode\":\"88607489357455572654\",\"goodsId\":\"186791599886416647\",\"activityName\":\"2元代金券da\",\"actualGoodsNumber\":1,\"discount\":66,\"type\":3},{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"186791599886416647\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":1700,\"type\":310,\"activityDesc\":\"套餐活动优惠\"}],\"goodsQuantity\":1,\"cartGoodType\":0}],\"apportionGoods\":[],\"stocks\":[],\"totalAmount\":400,\"discounts\":[{\"activityCode\":\"88607489357455572654\",\"activityName\":\"2元代金券da\",\"discount\":200,\"type\":3},{\"activityCode\":\"TCYH0000000001\",\"activityName\":\"套餐活动优惠\",\"discount\":1700,\"type\":310,\"activityDesc\":\"套餐活动优惠\"}],\"validCouponMap\":{}}";
        CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult = JSONObject.parseObject(discountResultStr, new TypeReference<CalculationSharingDiscountResponseDto.CalculationDiscountResult>() {
        });

        calculationSharingEquallyService.setShoppingCartGoodsDtoActivityDiscounts(discountResult, null);
        /**
         * 用促销价格初始化购物车行记录成交价
         */
        calculationCommonService.initShoppingCart(discountResult, cartGoodsList, shoppingCartGoodsResponseVo);
        /**
         * 满减处理
         */
        //fullSharingService.fullResponse(discountResult, cartGoodsList, shoppingCartGoodsResponseVo, null);
        List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods> goods = discountResult.getGoods();
        /**
         * 利用促销赋值totalDiscountAmount
         */
        List<ShoppingCartGoodsDto.CartGoodsDetailDto> cartGoodsDetailDtoList = new ArrayList<>();
        shoppingCartGoodsResponseVo.setProducts(cartGoodsList);
        for (CartGoods product : shoppingCartGoodsResponseVo.getProducts()) {
            CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods find = goods.stream().filter((k) -> k.getCartGoodsUid().equals(product.getCartGoodsUid())).findFirst().get();
            ShoppingCartGoodsDto.CartGoodsDetailDto cartGoodsDetailDto = calculationCommonService.convertCartGoods2DetailGoodsList(find, product,"");
            cartGoodsDetailDtoList.add(cartGoodsDetailDto);
        }
    }


    @Test
    public void cartTest2() {
        ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo = new ShoppingCartGoodsResponseVo();
        /**
         * json string
         */
        String cartGoodsListStr = "[{\"spuName\":\"苦瓜炒蛋套餐\",\"originalPrice\":1500,\"goodsId\":\"178391895271016481\",\"productMaterialList\":[],\"customerCode\":\"623004\",\"finalPrice\":400,\"createTimeMili\":1603540939607,\"pic\":\"https://picture.sandload.cn/1592902367135.png\",\"productComboList\":[{\"spuName\":\"土豆丝（单规格多属性）\",\"originalPrice\":600,\"goodsId\":\"179027590034491425\",\"customerCode\":\"630003\",\"finalPrice\":600,\"pic\":\"https://picture.sandload.cn/1593508615637.png\",\"extra\":[{\"attributeId\":\"150004883519628862\",\"attributeName\":\"酸\"}],\"specProductId\":\"150004883519628862\",\"skuId\":\"179027590034491425\",\"amount\":600,\"weight\":0.0,\"tax\":0.0,\"weightType\":false,\"unit\":\"\",\"originalAmount\":600,\"subName\":\"酸\",\"taxId\":\"\",\"qty\":1,\"name\":\"土豆丝（单规格多属性）\"}],\"categoryName\":\"套餐\",\"originalMaterialAmount\":0,\"packPrice\":0,\"skuName\":\"苦瓜炒蛋套餐\",\"riseSell\":1,\"classificationName\":\"\",\"productGroupList\":[{\"spuName\":\"小黄鱼\",\"originalPrice\":300,\"goodsId\":\"178391360377718801\",\"productGroupId\":178391681301743642,\"customerCode\":\"623001\",\"finalPrice\":300,\"pic\":\"https://picture.sandload.cn/1592901882290.png\",\"extra\":[{\"attributeId\":\"170958104935075359\",\"attributeName\":\"江浙口味\"}],\"specProductId\":\"170958104935075359\",\"skuId\":\"178391360377718801\",\"amount\":900,\"weight\":0.01,\"tax\":0.0,\"weightType\":false,\"unit\":\"\",\"originalAmount\":900,\"subName\":\"江浙口味\",\"taxId\":\"\",\"qty\":3,\"name\":\"小黄鱼\"}],\"memberDiscount\":100,\"skuId\":\"178391895271016481\",\"amount\":3000,\"cartGoodsUid\":\"9cd33af9-5404-42d1-bd1e-d0d63fb14c10\",\"stockLimit\":false,\"weight\":0.01,\"tax\":0.0,\"classificationId\":\"\",\"goodsType\":3,\"weightType\":false,\"unit\":\"\",\"originalAmount\":3000,\"subName\":\"\",\"taxId\":\"\",\"qty\":2,\"name\":\"苦瓜炒蛋套餐\",\"materialAmount\":0,\"spuId\":\"178391895271016481\"}]";
        List<CartGoods> cartGoodsList = JSONObject.parseObject(cartGoodsListStr, new TypeReference<List<CartGoods>>() {
        });

        String discountResultStr = "{\"couponDiscounts\":[],\"originalTotalAmount\":3000,\"totalDiscountAmount\":400,\"deliveryAmount\":0,\"distributionFee\":0,\"goods\":[{\"gift\":false,\"smallMaterial\":[{\"realAmount\":1800,\"discounts\":[],\"originalPrice\":300,\"goodsId\":\"178391360377718801\",\"discountAmount\":0,\"goodsQuantity\":3,\"type\":2}],\"groupCombox\":[{\"discounts\":[{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"179027590034491425\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":200,\"type\":310,\"activityDesc\":\"套餐活动优惠\"}],\"originalPrice\":600,\"goodsId\":\"179027590034491425\",\"discountAmount\":200,\"goodsQuantity\":1}],\"cartGoodsUid\":\"9cd33af9-5404-42d1-bd1e-d0d63fb14c10\",\"originalPrice\":800,\"goodsId\":\"178391895271016481\",\"discountAmount\":400,\"meal\":true,\"realAmount\":800,\"nowPrice\":400,\"discounts\":[{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"178391895271016481\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":400,\"type\":310,\"activityDesc\":\"套餐活动优惠\"}],\"goodsQuantity\":2,\"cartGoodType\":0}],\"apportionGoods\":[],\"sendGoods\":[{\"activityCode\":\"MEHG2020102214560528765\",\"activityName\":\"丹妮加价购\",\"activityType\":81,\"maxNum\":5,\"sendGoods\":[{\"nowPrice\":200,\"originalPrice\":600,\"goodsId\":\"181544702925960972\",\"sendNumber\":1,\"category\":\"181544702925960972\",\"goodsName\":\"炒粉丝（单品多属性）\"},{\"nowPrice\":50,\"originalPrice\":350,\"goodsId\":\"189341737725073154\",\"sendNumber\":1,\"category\":\"189341737668450102\",\"goodsName\":\"橘子多规格商品5/中份\"},{\"nowPrice\":50,\"originalPrice\":250,\"goodsId\":\"189341811077158681\",\"sendNumber\":1,\"category\":\"189341811009001230\",\"goodsName\":\"橘子多规格商品6/小杯\"},{\"nowPrice\":100,\"originalPrice\":400,\"goodsId\":\"189341921807832876\",\"sendNumber\":1,\"category\":\"189341921743869728\",\"goodsName\":\"橘子多规格商品7/小杯\"},{\"nowPrice\":100,\"originalPrice\":480,\"goodsId\":\"189342089362937651\",\"sendNumber\":1,\"category\":\"189342089362937651\",\"goodsName\":\"橘子单品多属性1\"}],\"minNum\":0,\"sendKinds\":0}],\"stocks\":[{\"activityCode\":\"MEHG2020102214560528765\",\"activityType\":81,\"goodsStock\":[{\"goodsId\":\"181544702925960972\",\"stock\":1},{\"goodsId\":\"189341737725073154\",\"stock\":1},{\"goodsId\":\"189341811077158681\",\"stock\":1},{\"goodsId\":\"189341921807832876\",\"stock\":1},{\"goodsId\":\"189342089362937651\",\"stock\":1}]}],\"totalAmount\":2600,\"discounts\":[{\"activityCode\":\"MEHG2020102214560528765\",\"activityName\":\"丹妮加价购\",\"discount\":0,\"type\":81,\"activityDesc\":\"\"},{\"activityCode\":\"MZSJD2020102118090314986\",\"activityName\":\"咖啡实验室\",\"discount\":0,\"type\":221,\"activityDesc\":\"集齐咖啡元素兑换大杯摩卡\"},{\"activityCode\":\"TCYH0000000001\",\"activityName\":\"套餐活动优惠\",\"discount\":400,\"type\":310,\"activityDesc\":\"套餐活动优惠\"}],\"validCouponMap\":{}}";
        CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult = JSONObject.parseObject(discountResultStr, new TypeReference<CalculationSharingDiscountResponseDto.CalculationDiscountResult>() {
        });
        ShoppingCartGoodsDto shoppingCartGoodsDto = new ShoppingCartGoodsDto();
        calculationSharingEquallyService.setShoppingCartGoodsDtoActivityDiscounts(discountResult, shoppingCartGoodsDto);
        ///**
        // * 用促销价格初始化购物车行记录成交价
        // */
        calculationCommonService.initShoppingCart(discountResult, cartGoodsList, shoppingCartGoodsResponseVo);
        /**
         * 满减处理
         */
        // fullSharingService.fullResponse(discountResult, cartGoodsList, shoppingCartGoodsResponseVo, null);
        List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods> goods = discountResult.getGoods();
        /**
         * 利用促销赋值totalDiscountAmount
         */
        List<ShoppingCartGoodsDto.CartGoodsDetailDto> cartGoodsDetailDtoList = new ArrayList<>();
        shoppingCartGoodsResponseVo.setProducts(cartGoodsList);
        for (CartGoods product : shoppingCartGoodsResponseVo.getProducts()) {
            CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods find = goods.stream().filter((k) -> k.getCartGoodsUid().equals(product.getCartGoodsUid())).findFirst().get();
            ShoppingCartGoodsDto.CartGoodsDetailDto cartGoodsDetailDto = calculationCommonService.convertCartGoods2DetailGoodsList(find, product,"");
            cartGoodsDetailDtoList.add(cartGoodsDetailDto);
        }
        //ShoppingCartInfoRequestVo
        String shoppingCartInfoRequestVoStr = "[{\"premiumExchangeActivity\":{\"activityCode\":\"MEHG2020102214560528765\",\"activityName\":\"丹妮加价购\",\"products\":[{\"attributes\":[{\"attributeId\":\"170958094128451102\",\"attributeValue\":\"四川口味\"}],\"originalPrice\":600,\"qty\":1,\"skuId\":\"181544702925960972\",\"skuName\":\"炒粉丝（单品多属性）\",\"spuId\":\"181544702925960972\"},{\"attributes\":[],\"originalPrice\":150,\"qty\":1,\"skuId\":\"189341737725073154\",\"skuName\":\"橘子多规格商品5/中份\",\"spuId\":\"189341737668450102\"}]},\"shoppingCartInfoRequestVo\":{\"flag\":0,\"menuType\":\"saas\",\"orderType\":1,\"partnerId\":\"2227\",\"reachStoreType\":5,\"sendGoods\":[{\"activityCode\":\"MEHG2020102214560528765\",\"goodsId\":\"181544702925960972\",\"originalPrice\":600,\"qty\":1},{\"activityCode\":\"MEHG2020102214560528765\",\"goodsId\":\"189341737725073154\",\"originalPrice\":150,\"qty\":1}],\"sessionId\":\"6a9fab57ef89904ad91224ee76d9d25b21d4694f\",\"shopId\":\"716001\",\"useCustomerScore\":2,\"version\":\"2.0.2.3\"}}]";
        GetShoppingCartGoodsApportionRequestVo getShoppingCartGoodsApportionRequestVo = JSONObject.parseObject(shoppingCartInfoRequestVoStr, new TypeReference<GetShoppingCartGoodsApportionRequestVo>() {
        });
        /**
         * 加价购商品
         */
        additionSharingService.equally(getShoppingCartGoodsApportionRequestVo.getShoppingCartInfoRequestVo(), null, discountResult, getShoppingCartGoodsApportionRequestVo.getPremiumExchangeActivity(), null);
    }

    @Test
    public void gift() {
        ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo = new ShoppingCartGoodsResponseVo();
        /**
         * json string
         */
        String cartGoodsListStr = "[{\"spuName\":\"棒棒鸡001测试下它的名称有多长呀\",\"originalPrice\":80,\"goodsId\":\"178866782811063078\",\"productMaterialList\":[],\"customerCode\":\"W784564616546461\",\"finalPrice\":80,\"createTimeMili\":1603174607026,\"pic\":\"https://picture.sandload.cn/1601446435601.jpg\",\"productComboList\":[],\"categoryName\":\"买赠赠小样\",\"originalMaterialAmount\":0,\"packPrice\":100,\"skuName\":\"棒棒鸡001测试下它的名称有多长呀\",\"riseSell\":1,\"classificationName\":\"面\",\"productGroupList\":[],\"memberDiscount\":78,\"skuId\":\"\",\"amount\":80,\"cartGoodsUid\":\"843d540c-0056-4a32-a02b-8798c886345c\",\"stockLimit\":true,\"weight\":0.01,\"tax\":0.01,\"classificationId\":\"noodlenoodlenoodleno\",\"goodsType\":5,\"weightType\":false,\"unit\":\"杯\",\"originalAmount\":80,\"subName\":\"\",\"taxId\":\"\",\"qty\":1,\"name\":\"棒棒鸡001测试下它的名称有多长呀\",\"materialAmount\":0,\"spuId\":\"178866782811063078\"}]";
        List<CartGoods> cartGoodsList = JSONObject.parseObject(cartGoodsListStr, new TypeReference<List<CartGoods>>() {
        });

        String discountResultStr = "{\"couponDiscounts\":[],\"originalTotalAmount\":120,\"totalDiscountAmount\":57,\"deliveryAmount\":0,\"distributionFee\":0,\"goods\":[{\"gift\":false,\"smallMaterial\":[],\"cartGoodsUid\":\"843d540c-0056-4a32-a02b-8798c886345c\",\"originalPrice\":80,\"goodsId\":\"178866782811063078\",\"actualGoodsNumber\":1,\"discountAmount\":17,\"meal\":false,\"realAmount\":63,\"nowPrice\":63,\"discounts\":[{\"activityCode\":\"SPHYJ0000000001\",\"goodsId\":\"178866782811063078\",\"activityName\":\"商品会员价\",\"actualGoodsNumber\":1,\"discount\":17,\"type\":320}],\"goodsQuantity\":1,\"cartGoodType\":0},{\"gift\":false,\"originalPrice\":20,\"goodsId\":\"146135281451628826\",\"discountAmount\":40,\"meal\":false,\"realAmount\":0,\"nowPrice\":0,\"discounts\":[{\"activityCode\":\"BNSP2020092717540005004\",\"goodsId\":\"146135281451628826\",\"activityName\":\"柚子的买赠\",\"actualGoodsNumber\":2,\"discount\":40,\"type\":62}],\"goodsQuantity\":2,\"cartGoodType\":1}],\"apportionGoods\":[],\"sendGoods\":[],\"stocks\":[],\"totalAmount\":63,\"discounts\":[{\"activityCode\":\"SPHYJ0000000001\",\"activityName\":\"商品会员价\",\"discount\":17,\"type\":320,\"activityDesc\":\"商品会员价\"},{\"activityCode\":\"BNSP2020092717540005004\",\"activityName\":\"柚子的买赠\",\"discount\":40,\"type\":62,\"activityDesc\":\"\"}],\"validCouponMap\":{}}";
        CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult = JSONObject.parseObject(discountResultStr, new TypeReference<CalculationSharingDiscountResponseDto.CalculationDiscountResult>() {
        });
        /**
         * 用促销价格初始化购物车行记录成交价
         */
        calculationCommonService.initShoppingCart(discountResult, cartGoodsList, shoppingCartGoodsResponseVo);
        /**
         * 利用促销赋值totalDiscountAmount
         */
        List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods> goods = discountResult.getGoods();
        List<ShoppingCartGoodsDto.CartGoodsDetailDto> cartGoodsDetailDtoList = new ArrayList<>();
        shoppingCartGoodsResponseVo.setProducts(cartGoodsList);
        shoppingCartGoodsResponseVo.setProducts(cartGoodsList);
        for (CartGoods product : shoppingCartGoodsResponseVo.getProducts()) {
            CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods find = goods.stream().filter((k) -> k.getCartGoodsUid().equals(product.getCartGoodsUid())).findFirst().get();
            ShoppingCartGoodsDto.CartGoodsDetailDto cartGoodsDetailDto = calculationCommonService.convertCartGoods2DetailGoodsList(find, product,"");
            cartGoodsDetailDtoList.add(cartGoodsDetailDto);
        }
        /**
         * 赠品
         */
        giftSharingService.equally(discountResult, cartGoodsDetailDtoList, null, "saas");
    }

    @Test
    public void product() {
        String productStr = "{\"additionalGroupList\":[],\"barcode\":\"\",\"brandId\":\"\",\"brandName\":\"\",\"businessNo\":\"\",\"businessType\":\"\",\"category\":\"\",\"categoryName\":\"\",\"companyId\":\"2399\",\"completeFlag\":0,\"customerCode\":\"170796389234812474\",\"customerName\":\"\",\"detailImages\":[],\"detailText\":\"\",\"finalPrice\":2,\"isDishware\":0,\"isSkuProduct\":1,\"labelNames\":[],\"maxLimitNumber\":0,\"maxRestrictionQty\":0,\"memberDiscount\":0,\"minLimitNumber\":0,\"minRestrictionQty\":0,\"name\":\"柚子的多规格螃蟹/大杯\",\"openMemberDiscount\":0,\"options\":\"\",\"originalPrice\":2,\"otherDesc\":\"\",\"packPrice\":0,\"picture\":\"https://img10.sandload.cn/柚子的多规格螃蟹.jpg?timestamp=1594117985325\",\"pid\":\"170796389234812474\",\"pknumber\":0,\"priceSource\":1,\"productAttributeGroupList\":[],\"productBindingCouponTypes\":[],\"productCategoryDetailList\":[],\"productCode\":\"\",\"productComboList\":[],\"productGroupList\":[],\"productPictureList\":[{\"sequence\":0,\"type\":\"default\",\"url\":\"https://img10.sandload.cn/柚子的多规格螃蟹.jpg?timestamp=1594117985325\"}],\"productSpecification\":[],\"productionLocation\":\"\",\"rawMaterial\":\"\",\"remark\":\"\",\"riseSell\":1,\"saleCount\":0,\"salesChannel\":\"\",\"sellTimeList\":[],\"sellTimeMonthList\":[],\"sellTimeRangeList\":[],\"sellTimeValid\":true,\"sequence\":0,\"shopLongTermSalesVolume\":0,\"shopShortTermSalesVolume\":0,\"skuList\":[],\"skuSpecValues\":[{\"productId\":\"170796389234812474\",\"sequence\":2,\"specAttrValues\":[],\"specCustomerCode\":\"hyjbx\",\"specId\":\"170796304154404393\",\"specName\":\"韩月季_杯型\",\"specValue\":\"大杯\",\"specValueCustomerCode\":\"33\",\"specValueId\":\"170796324362561068\"}],\"sourceChannel\":\"\",\"specProductId\":\"\",\"specification\":\"\",\"specificationGroupList\":[],\"specificationList\":[],\"standardGoodsFlag\":0,\"status\":1,\"stock\":9999,\"stockLimit\":2,\"storeCondition\":\"\",\"storeProductName\":\"\",\"tax\":0,\"taxId\":\"\",\"type\":1,\"unit\":\"g\",\"valid\":false,\"version\":0,\"weight\":2,\"weightType\":0}";
        GetProductsVo getProductsVo = JSONObject.parseObject(productStr, new TypeReference<GetProductsVo>() {
        });
        if (null == getProductsVo || !Objects.equals(getProductsVo.getStatus(), StoreItemStatus.PUT_ON_SALE.getCode())) {
            return;
        }
    }


}
