package cn.freemud.service.impl.mcoffee.entity;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: MCCafeCouponRequest
 * @Package cn.freemud.service.impl.mcoffee.entity
 * @Description:
 * @author: ping1.wu
 * @date: 2020/9/10 15:23
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

@Data
public class MCCafeCouponRequest {

    /**
     * 接口版本
     */
    private Integer ver;

    /**
     * kdg.Y 开个店渠道且需要回调三方
     * kgd.N 开个店渠道且不需要回调三方
     */
//    private String appFlag;
    /**
     * 需要查询的券码，仅供查询券使用
     */
//    private String coupon;
    /**
     * 请求操作类型，0是卡券查询，2是卡券交易查询，3是卡券冲正，71是卡券核销
     */
    private Integer reqtype;
    /**
     * 商家门店号
     */
    private String store_id;

    /**
     * 子品牌 ID 可以为空
     */
//    private String organize_id;

    /**
     * 组织机构ID(注意和channle的区别)
     */
//    private List<String> channel_ids;

    /**
     * 组织机构code(注意和channle的区别)
     */
//    private List<String> channel_codes;

    /**
     * 商家POS机编号
     */
    private String station_id;
    /**
     * 营业员编号
     */
    private String operator_id;
    /**
     * 商户编号
     */
    private Integer partnerId;

//    private Integer checkValue;

//    private Integer clientReqCount;
    /**
     * POS交易序号
     */
//    private String trans_id;
    /**
     * 营业日
     */
//    private String business_date;
    /**
     * 优惠券列表
     */
//    private List<MCCafeTransactionVo> transactions;
    /**
     * 签名
     */
    private String sign;
    /**
     * 追加key
     */
//    private String appSecret;

//    private String openid;

//    private String transactionuuid;

//    private String status;

//    private Boolean isManual;

    //核销渠道，麦咖啡微信小程序就传 mocoffee_wx，麦咖啡支付宝小程序就传 mocoffee_zfb
    private String channel;

    private List<CouponCodeVo> couponlist;

}
