package cn.freemud.management.intercept;

import cn.freemud.management.enums.ResponseResult;
import com.freemud.application.sdk.api.exception.IgnoreErrorAnnotation;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OrderServiceException
 * @Package cn.freemud.management.intercept
 * @Description:
 * @author: shuhu.hou
 * @date: 2020/4/23 11:37
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@IgnoreErrorAnnotation
public class PaymentServiceException extends RuntimeException {

    private ResponseResult result;

    private String message;

    public PaymentServiceException(ResponseResult result) {
        this.result = result;
        this.message = result.getMessage();
    }

    public PaymentServiceException(ResponseResult result, String message) {
        this.result = result;
        this.message = message;
    }

    public ResponseResult getResult() {
        return result;
    }

    public void setResult(ResponseResult result) {
        this.result = result;
    }

    @Override
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}