/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderCallBackController
 * @Package cn.freemud.controller
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/15 18:51
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.OrderCallBackRequestVo;
import cn.freemud.service.OrderCallBackService;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import lombok.extern.log4j.Log4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

@RestController
@RequestMapping(value = "/callback", consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class CallBackController {

    @Autowired
    private OrderCallBackService orderCallBackService;

    @PostMapping("/order")
    @ApiAnnotation(logMessage = "/order")
    public BaseResponse orderCallBackHandle(@Valid @RequestBody @LogParams OrderCallBackRequestVo requestVo) {
        return orderCallBackService.orderCallBackHandle(requestVo);
    }

}
