package cn.freemud.fuyou.feign.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 条码支付请求对象
 * <p>
 * 此对象目前作为过期的适配对象，将来在某个版本需要移除
 *
 * @author yuanyuan.jing 2018/12/14 17:57
 * @author Tony
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "付款码支付请求")
public class CodePayRequest extends CodePayReq {

    @Min(value = 0, message = "支付总金额最小是0")
    @NotNull(message = "支付总金额不能为空")
    @ApiModelProperty(value = "支付总金额，以分为单位", position = 8, required = true)
    private long amount;

    @NotEmpty(message = "支付条码不能为空")
    @ApiModelProperty(value = "支付条码", position = 10)
    private String code;

    @ApiModelProperty(value = "不可打折金额，以分为单位", position = 11)
    private long undisAmount;

    @ApiModelProperty(value = "支付商品信息", position = 12)
    private List<Product> products;

    @NotEmpty(message = "订单描述不能为空")
    @ApiModelProperty(value = "订单描述")
    private String body;

    @ApiModelProperty(value="分账详情，json串，具体参照相关渠道文档" )
    private String divideDetail;

    /**
     * 此处冗余原基类字段信息
     */
    @ApiModelProperty(value = "接口版本，必须为2", position = 1)
    private String ver;

    @ApiModelProperty(value = "商户编号（由非码提供）", position = 2, required = true)
    private String partnerId;

    @ApiModelProperty(value = "商家门店号（在线支付需要提前定义）", position = 3, required = true)
    private String storeId;

    @ApiModelProperty(value = "商家POS机编号（可以使用固定值）", position = 4, required = true)
    private String stationId;

    @ApiModelProperty(value = "营业员编号（可以使用固定值）", position = 5, required = true)
    private String operatorId;

    @ApiModelProperty(value = "业务日期", position = 7)
    private String businessDate;

    @ApiModelProperty(value = "终端交易序号", position = 6, required = true)
    private String transId;

    @ApiModelProperty(value = "客户端code", position = 8, required = true)
    private Long clientCode;

    @ApiModelProperty(value = "支付超时时间")
    private String payTimeOutTime;
}
